/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.entity.contact.user.UserListResp;
import cn.kinyun.wework.sdk.entity.contact.user.UserSimpleInfo;
import cn.kinyun.wework.sdk.entity.contact.user.UserSimpleListResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class UserApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.user.get}")
    private String wwUserGet;
    @Value(value="${qyapi.user.update}")
    private String wwUserUpdate;
    @Value(value="${qyapi.user.simplelist}")
    private String wwUserSimpleList;
    @Value(value="${qyapi.user.list}")
    private String wwUserList;
    @Value(value="${qyapi.user.create}")
    private String wwUserCreate;

    public UserInfo get(@NonNull String accessToken, @NonNull String userId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwUserGet, accessToken, userId);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, UserInfo.class, new Object[0]);
        UserInfo userInfo = (UserInfo)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)userInfo);
        return userInfo;
    }

    public List<UserSimpleInfo> simpleList(@NonNull String accessToken, @NonNull Integer departmentId, @GenNullable Integer fetchChild) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        if (fetchChild == null) {
            fetchChild = 0;
        }
        String url = MessageFormat.format(this.wwUserSimpleList, accessToken, String.valueOf(departmentId), fetchChild);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, UserSimpleListResp.class, new Object[0]);
        UserSimpleListResp result = (UserSimpleListResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getUserList();
    }

    public List<UserInfo> list(@NonNull String accessToken, @NonNull Integer departmentId, @GenNullable Integer fetchChild) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        if (fetchChild == null) {
            fetchChild = 0;
        }
        String url = MessageFormat.format(this.wwUserList, accessToken, String.valueOf(departmentId), fetchChild);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, UserListResp.class, new Object[0]);
        UserListResp result = (UserListResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getUserList();
    }

    public void updateDepartment(@NonNull String accessToken, @NonNull String userId, @NonNull List<Integer> department) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (department == null) {
            throw new NullPointerException("department is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwUserUpdate, accessToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userid", userId);
        map.put("department", department);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public void update(@NonNull String accessToken, @NonNull UserInfo userInfo) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userInfo == null) {
            throw new NullPointerException("userInfo is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwUserUpdate, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)userInfo, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public void create(@NonNull String accessToken, @NonNull UserInfo userInfo) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userInfo == null) {
            throw new NullPointerException("userInfo is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwUserCreate, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)userInfo, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }
}

