/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.agent.Agent;
import cn.kinyun.wework.sdk.entity.agent.AgentList;
import cn.kinyun.wework.sdk.entity.agent.AgentMsgBase;
import cn.kinyun.wework.sdk.entity.agent.SendMsgResult;
import cn.kinyun.wework.sdk.entity.agent.SetAgentParams;
import cn.kinyun.wework.sdk.entity.agent.userid.ExternalUserId;
import cn.kinyun.wework.sdk.entity.agent.userid.UserIds;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AgentApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.agent.get}")
    private String wwAgentGet;
    @Value(value="${qyapi.agent.list}")
    private String wwAgentList;
    @Value(value="${qyapi.agent.set}")
    private String wwAgentSet;
    @Value(value="${qyapi.message.send}")
    private String wwMessageSend;
    @Value(value="${qyapi.service.openuserid_to_userid}")
    private String openUserId2UserId;
    @Value(value="${qyapi.externalcontact.from_service_external_userid}")
    private String openExternalUserId2externalUserId;

    public Agent getAgent(@NonNull String accessToken, @NonNull Integer agentId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwAgentGet, accessToken);
        url = url + "&agentid=" + agentId;
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, Agent.class, new Object[0]);
        Agent result = (Agent)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public AgentList getAgentList(@NonNull String accessToken) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwAgentList, accessToken);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, AgentList.class, new Object[0]);
        AgentList result = (AgentList)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public void setAgent(@NonNull String accessToken, @NonNull SetAgentParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwAgentSet, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    public SendMsgResult sendMsg(@NonNull String accessToken, @NonNull AgentMsgBase msg) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwMessageSend, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)msg, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, SendMsgResult.class, new Object[0]);
        SendMsgResult result = (SendMsgResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public UserIds convertOpenUserId(@NonNull String accessToken, @NonNull List<String> openUserIdList, @NonNull Integer sourceAgentId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openUserIdList == null) {
            throw new NullPointerException("openUserIdList is marked non-null but is null");
        }
        if (sourceAgentId == null) {
            throw new NullPointerException("sourceAgentId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.openUserId2UserId, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("open_userid_list", openUserIdList);
        params.put("source_agentid", sourceAgentId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserIds.class, new Object[0]);
        UserIds result = (UserIds)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public String convertOpenExternalUserId(@NonNull String accessToken, @NonNull String externalUserId, @NonNull Integer sourceAgentId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (externalUserId == null) {
            throw new NullPointerException("externalUserId is marked non-null but is null");
        }
        if (sourceAgentId == null) {
            throw new NullPointerException("sourceAgentId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.openExternalUserId2externalUserId, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("external_userid", externalUserId);
        params.put("source_agentid", sourceAgentId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ExternalUserId.class, new Object[0]);
        ExternalUserId result = (ExternalUserId)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getExternalUserId();
    }
}

