package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.productAlbum.AddProductAlbumParams;
import cn.kinyun.wework.sdk.entity.external.productAlbum.AddProductAlbumResp;
import cn.kinyun.wework.sdk.entity.external.productAlbum.DeleteProductAlbumParams;
import cn.kinyun.wework.sdk.entity.external.productAlbum.DeleteProductAlbumResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.Map;

/**
 * 商品图册 api
 **/
@Component
@Slf4j
public class ProductAlbumApi {

    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 添加商品图册接口地址
     */
    @Value("${qyapi.externalcontact.add_product_album}")
    private String addProductAlbumUrl;

    /**
     * 删除商品图册接口地址
     */
    @Value("${qyapi.externalcontact.delete_product_album}")
    private String deleteProductAlbumUrl;

    /**
     * 添加商品图册
     **/
    public AddProductAlbumResp add(@NonNull String accessToken,  @NonNull AddProductAlbumParams params) throws WeworkException {
        log.info("add product album params: {}", params);
        String url = MessageFormat.format(addProductAlbumUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<AddProductAlbumParams> httpEntity = new HttpEntity<>(params, headers);
        ResponseEntity<AddProductAlbumResp> forEntity = restTemplate.postForEntity(url, httpEntity, AddProductAlbumResp.class);
        AddProductAlbumResp result = forEntity.getBody();
        log.info("add product album result: {}", result);
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 删除商品图册
     **/
    public DeleteProductAlbumResp del(@NonNull String accessToken,  @NonNull DeleteProductAlbumParams params) throws WeworkException {
        String url = MessageFormat.format(deleteProductAlbumUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<DeleteProductAlbumParams> httpEntity = new HttpEntity<>(params, headers);
        ResponseEntity<DeleteProductAlbumResp> forEntity = restTemplate.postForEntity(url, httpEntity, DeleteProductAlbumResp.class);
        DeleteProductAlbumResp result = forEntity.getBody();
        return result;
    }
}
