package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.api.req.AddScheduleReq;
import cn.kinyun.wework.sdk.api.req.DelScheduleReq;
import cn.kinyun.wework.sdk.api.req.UpdateScheduleReq;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.calendar.ScheduleAddResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;

/**
 * 日程API
 * @author sunwen
 */
@Component
public class ScheduleApi {

    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 创建日程
     */
    @Value("${qyapi.schedule.add}")
    private String addSchedule;

    /**
     * 更新日程
     */
    @Value("${qyapi.schedule.update}")
    private String updateSchedule;

    /**
     * 取消日程
     */
    @Value("${qyapi.schedule.del}")
    private String delSchedule;

    @GenAsync
    public ScheduleAddResp addSchedule(@NonNull String accessToken, @NonNull AddScheduleReq params) throws WeworkException {
        String url = MessageFormat.format(addSchedule, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<AddScheduleReq> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<ScheduleAddResp> forEntity = restTemplate.postForEntity(url, httpEntity, ScheduleAddResp.class);

        ScheduleAddResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }

    @GenAsync
    public void updateSchedule(@NonNull String accessToken, @NonNull UpdateScheduleReq params) throws WeworkException {
        String url = MessageFormat.format(updateSchedule, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<UpdateScheduleReq> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<ErrorCode> forEntity = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);

        ErrorCode result = forEntity.getBody();
        WeworkException.isSuccess(result);
    }

    @GenAsync
    public void delSchedule(@NonNull String accessToken, @NonNull DelScheduleReq params) throws WeworkException {
        String url = MessageFormat.format(delSchedule, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<DelScheduleReq> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<ErrorCode> forEntity = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);

        ErrorCode result = forEntity.getBody();
        WeworkException.isSuccess(result);
    }
}
