/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    private XmlUtils() {
    }

    public static String obj2Xml(Object value) {
        try {
            return XML_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error("Generate xml failed, obj={}", value, (Object)e);
            return null;
        }
    }

    public static <T> T xml2Obj(String content, Class<T> valueType) {
        try {
            return (T)XML_MAPPER.readValue(content, valueType);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Parse xml failed, content={}", (Object)content, (Object)e);
            return null;
        }
    }

    static {
        XML_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        XML_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

