/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionContactList;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLinkDetail;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLinkList;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLinkReq;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionLinkResp;
import cn.kinyun.wework.sdk.entity.external.customeracquisition.CustomerAcquisitionQuota;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CustomerAcquisitionApi {
    private static final Logger log = LoggerFactory.getLogger(CustomerAcquisitionApi.class);
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.customer_acquisition.list_link}")
    private String listLinkUrl;
    @Value(value="${qyapi.externalcontact.customer_acquisition.get}")
    private String getLinkUrl;
    @Value(value="${qyapi.externalcontact.customer_acquisition.create_link}")
    private String createLinkUrl;
    @Value(value="${qyapi.externalcontact.customer_acquisition.update_link}")
    private String updateLinkUrl;
    @Value(value="${qyapi.externalcontact.customer_acquisition.delete_link}")
    private String deleteLinkUrl;
    @Value(value="${qyapi.externalcontact.customer_acquisition.customer}")
    private String getLinkCustomerUrl;
    @Value(value="${qyapi.externalcontact.customer_acquisition.quota}")
    private String getQuotaUrl;

    public CustomerAcquisitionLinkList listLink(@NonNull String accessToken, Integer limit, String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.listLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (limit != null) {
            params.put("limit", limit);
        }
        if (cursor != null) {
            params.put("cursor", cursor);
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CustomerAcquisitionLinkList.class, new Object[0]);
        CustomerAcquisitionLinkList result = (CustomerAcquisitionLinkList)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public CustomerAcquisitionLinkDetail getLink(@NonNull String accessToken, @NonNull String linkId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("link_id", linkId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CustomerAcquisitionLinkDetail.class, new Object[0]);
        CustomerAcquisitionLinkDetail result = (CustomerAcquisitionLinkDetail)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public CustomerAcquisitionLinkResp createLink(@NonNull String accessToken, @NonNull CustomerAcquisitionLinkReq linkReq) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (linkReq == null) {
            throw new NullPointerException("linkReq is marked non-null but is null");
        }
        String url = MessageFormat.format(this.createLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)linkReq, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CustomerAcquisitionLinkResp.class, new Object[0]);
        CustomerAcquisitionLinkResp result = (CustomerAcquisitionLinkResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void updateLink(@NonNull String accessToken, @NonNull CustomerAcquisitionLinkReq linkReq) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (linkReq == null) {
            throw new NullPointerException("linkReq is marked non-null but is null");
        }
        String url = MessageFormat.format(this.updateLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)linkReq, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    public void deleteLink(@NonNull String accessToken, @NonNull String linkId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.deleteLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("link_id", linkId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public CustomerAcquisitionContactList getLinkCustomer(@NonNull String accessToken, @NonNull String linkId, Integer limit, String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getLinkCustomerUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("link_id", linkId);
        if (limit != null) {
            params.put("limit", limit);
        }
        if (cursor != null) {
            params.put("cursor", cursor);
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CustomerAcquisitionContactList.class, new Object[0]);
        CustomerAcquisitionContactList result = (CustomerAcquisitionContactList)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public CustomerAcquisitionQuota getQuota(@NonNull String accessToken) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getQuotaUrl, accessToken);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, CustomerAcquisitionQuota.class, new Object[0]);
        CustomerAcquisitionQuota result = (CustomerAcquisitionQuota)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

