/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.crypt.AesException;
import cn.kinyun.wework.sdk.crypt.SHA1;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.Ticket;
import cn.kinyun.wework.sdk.entity.jssdk.JsSignReq;
import cn.kinyun.wework.sdk.entity.jssdk.JsSignResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class JsSdkApi {
    private static final Logger log = LoggerFactory.getLogger(JsSdkApi.class);
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.get_ticket}")
    private String wwGetTicket;
    @Value(value="${qyapi.get_jsapi_ticket}")
    private String wwGetJsapiTicket;

    public Ticket getAgentTicket(@NonNull String accessToken) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return this.getTicketByType(accessToken, "agent_config");
    }

    public Ticket getTicketByType(@NonNull String accessToken, @NonNull String type) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        log.info("get ticket with type={}", (Object)type);
        String url = MessageFormat.format(this.wwGetTicket, accessToken, type);
        ResponseEntity response = this.restTemplate.getForEntity(url, Ticket.class, new Object[0]);
        Ticket ticket = (Ticket)response.getBody();
        WeworkException.isSuccess((ErrorCode)ticket);
        return ticket;
    }

    public Ticket getJsapiTicket(@NonNull String accessToken) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get jsapi ticket");
        String url = MessageFormat.format(this.wwGetJsapiTicket, accessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, Ticket.class, new Object[0]);
        Ticket ticket = (Ticket)response.getBody();
        WeworkException.isSuccess((ErrorCode)ticket);
        return ticket;
    }

    @GenIgnore
    public JsSignResp signature(@NonNull JsSignReq data, @NonNull String jsApiTicket) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (jsApiTicket == null) {
            throw new NullPointerException("jsApiTicket is marked non-null but is null");
        }
        log.info("signature for data={}", (Object)data);
        String url = data.getUrl();
        String nonceStr = data.getNonceStr();
        String timestamp = data.getTimestamp();
        StringBuilder sb = new StringBuilder(64);
        sb.append("jsapi_ticket=").append(jsApiTicket).append("&noncestr=").append(nonceStr).append("&timestamp=").append(timestamp).append("&url=").append(url);
        String signature = null;
        try {
            signature = SHA1.sha1((String)sb.toString());
        }
        catch (AesException e) {
            e.printStackTrace();
        }
        JsSignResp sign = new JsSignResp();
        sign.setNonceStr(nonceStr);
        sign.setTimestamp(timestamp);
        sign.setSignature(signature);
        return sign;
    }
}

