package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.license.account.*;
import cn.kinyun.wework.sdk.entity.license.order.CreateRenewOrderJobReq;
import cn.kinyun.wework.sdk.entity.license.order.CreateRenewOrderJobResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;

/**
 * @author: lwl
 * @date: 2023/5/15
 * @description:  接口调用许可 -- 账号管理
 *
 * @link https://developer.work.weixin.qq.com/document/path/95553
 **/
@Component

public class LicenseAccountApi {

    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 激活账号
     */
    @Value("${qyapi.license.active_account}")
    private String licenseActiveAccountUrl;

    /**
     * 批量激活账号
     */
    @Value("${qyapi.license.batch_active_account}")
    private String licenseBatchActiveAccountUrl;

    /**
     * 获取激活码详情
     */
    @Value("${qyapi.license.get_active_info_by_code}")
    private String licenseGetActiveInfoByCodeUrl;

    /**
     * 批量获取激活码详情
     */
    @Value("${qyapi.license.batch_get_active_info_by_code}")
    private String licenseBatchGetActiveInfoByCodeUrl;

    /**
     * 获取企业的账号列表
     */
    @Value("${qyapi.license.list_actived_account}")
    private String licenseListActivatedAccountUrl;

    /**
     * 获取成员的激活详情
     */
    @Value("${qyapi.license.get_active_info_by_user}")
    private String licenseGetActiveInfoByUserUrl;

    /**
     * 获取企业的账号列表
     */
    @Value("${qyapi.license.batch_transfer_license}")
    private String licenseBatchTransferUrl;

    /**
     * 分配激活码给下游企业
     */
    @Value("${qyapi.license.batch_share_active_code}")
    private String licenseBatchShareActiveCodeUrl;


    /**
     * 激活账号
     *
     * @link https://developer.work.weixin.qq.com/document/path/95553
     */
    public void activeAccount(@NonNull String accessToken, @NonNull ActiveAccountReq req) throws WeworkException {
        String url = MessageFormat.format(licenseActiveAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<ActiveAccountReq> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<ErrorCode> forEntity = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);
        ErrorCode result = forEntity.getBody();
        WeworkException.isSuccess(result);
    }

    /**
     * 批量激活账号
     *
     * @link https://developer.work.weixin.qq.com/document/path/95553
     **/
    public BatchActiveAccountResp batchActiveAccount(@NonNull String accessToken, @NonNull BatchActiveAccountReq req) throws WeworkException {
        String url = MessageFormat.format(licenseBatchActiveAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<BatchActiveAccountReq> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<BatchActiveAccountResp> forEntity = restTemplate.postForEntity(url, httpEntity, BatchActiveAccountResp.class);
        BatchActiveAccountResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 获取激活码详情
     *
     * @link https://developer.work.weixin.qq.com/document/path/95552
     **/
    public GetActiveInfoByCodeResp getActiveInfoByCode(@NonNull String accessToken, @NonNull GetActiveInfoByCodeReq req) throws WeworkException {
        String url = MessageFormat.format(licenseGetActiveInfoByCodeUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<GetActiveInfoByCodeReq> httpEntity = new HttpEntity<>(req,headers);
        ResponseEntity<GetActiveInfoByCodeResp> forEntity = restTemplate.postForEntity(url, httpEntity, GetActiveInfoByCodeResp.class);
        GetActiveInfoByCodeResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 批量获取激活码详情
     *
     * @link https://developer.work.weixin.qq.com/document/path/95552
     **/
    public BatchGetActiveInfoByCodeResp batchGetActiveInfoByCode(@NonNull String accessToken, @NonNull BatchGetActiveInfoByCodeReq req) throws WeworkException {
        String url = MessageFormat.format(licenseGetActiveInfoByCodeUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<BatchGetActiveInfoByCodeReq> httpEntity = new HttpEntity<>(req,headers);
        ResponseEntity<BatchGetActiveInfoByCodeResp> forEntity = restTemplate.postForEntity(url, httpEntity, BatchGetActiveInfoByCodeResp.class);
        BatchGetActiveInfoByCodeResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 获取企业的账号列表
     *
     * @link https://developer.work.weixin.qq.com/document/path/95552
     **/
    public ListActivatedAccountResp listActivatedAccount(@NonNull String accessToken, @NonNull ListActivatedAccountReq req) throws WeworkException {
        String url = MessageFormat.format(licenseListActivatedAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<ListActivatedAccountReq> httpEntity = new HttpEntity<>(req,headers);
        ResponseEntity<ListActivatedAccountResp> forEntity = restTemplate.postForEntity(url, httpEntity, ListActivatedAccountResp.class);
        ListActivatedAccountResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 获取成员的激活详情
     *
     * @link https://developer.work.weixin.qq.com/document/path/95555
     **/
    public GetActiveInfoByUserResp getActiveInfoByUser(@NonNull String accessToken, @NonNull GetActiveInfoByUserReq req) throws WeworkException {
        String url = MessageFormat.format(licenseGetActiveInfoByUserUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<GetActiveInfoByUserReq> httpEntity = new HttpEntity<>(req,headers);
        ResponseEntity<GetActiveInfoByUserResp> forEntity = restTemplate.postForEntity(url, httpEntity, GetActiveInfoByUserResp.class);
        GetActiveInfoByUserResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 账号继承
     *
     * @link  https://developer.work.weixin.qq.com/document/path/95673
     **/
    public BatchTransferLicenseResp batchTransferLicense(@NonNull String accessToken, @NonNull BatchTransferLicenseReq req) throws WeworkException {
        String url = MessageFormat.format(licenseBatchTransferUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<BatchTransferLicenseReq> httpEntity = new HttpEntity<>(req,headers);
        ResponseEntity<BatchTransferLicenseResp> forEntity = restTemplate.postForEntity(url, httpEntity, BatchTransferLicenseResp.class);
        BatchTransferLicenseResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

    /**
     * 分配激活码给下游企业
     *
     * @link  https://developer.work.weixin.qq.com/document/path/95673
     **/
    public BatchShareActiveCodeResp batchShareActiveCode(@NonNull String accessToken, @NonNull BatchShareActiveCodeReq req) throws WeworkException {
        String url = MessageFormat.format(licenseBatchShareActiveCodeUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<BatchShareActiveCodeReq> httpEntity = new HttpEntity<>(req,headers);
        ResponseEntity<BatchShareActiveCodeResp> forEntity = restTemplate.postForEntity(url, httpEntity, BatchShareActiveCodeResp.class);
        BatchShareActiveCodeResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }
}
