package cn.kinyun.wework.sdk.api.external;


import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.AddMaterialParams;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.MaterialConfigResult;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.MaterialInfo;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.UpdateMaterialParams;
import cn.kinyun.wework.sdk.exception.WeworkException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

import lombok.NonNull;

/**
 * 入群欢迎语素材管理
 */
@Component
public class JoinGroupMaterialApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 添加入群欢迎语素材
     */
    @Value("${qyapi.material.manager.add}")
    private String addMaterialUrl;

    /**
     * 编辑入群欢迎语素材
     */
    @Value("${qyapi.material.manager.edit}")
    private String editMaterialUrl;

    /**
     * 获取入群欢迎素材
     */
    @Value("${qyapi.material.manager.get}")
    private String getMaterialUrl;

    /**
     * 删除入群欢迎素材
     */
    @Value("${qyapi.material.manager.del}")
    private String delMaterialUrl;


    /**
     * @param accessToken
     * @param params
     * @desc 添加入群欢迎语素材  企业可通过此API向企业的入群欢迎语素材库中添加素材
     * @link https://open.work.weixin.qq.com/api/doc/90000/90135/92366
     */
    @GenAsync
    public MaterialConfigResult add(@NonNull String accessToken, @NonNull AddMaterialParams params) throws WeworkException {
        String url = MessageFormat.format(addMaterialUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<AddMaterialParams> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<MaterialConfigResult> forEntity = restTemplate.postForEntity(url, httpEntity, MaterialConfigResult.class);

        MaterialConfigResult result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }

    /**
     * @desc 编辑入群欢迎语素材  企业可通过此API编辑入群欢迎语素材库中的素材，且仅能够编辑调用方自己创建的入群欢迎语素材
     * @param accessToken
     * @param params
     * @link https://open.work.weixin.qq.com/api/doc/90000/90135/92366
     */
    @GenAsync
    public void update(@NonNull String accessToken, @NonNull UpdateMaterialParams params) throws WeworkException {
        String url = MessageFormat.format(editMaterialUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<UpdateMaterialParams> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<ErrorCode> forEntity = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);

        ErrorCode result = forEntity.getBody();
        WeworkException.isSuccess(result);
    }

    /**
     * @desc 获取入群欢迎语素材 企业可通过此API获取入群欢迎语素材
     * @param accessToken
     * @param templateId 群欢迎语的素材id
     * @link https://open.work.weixin.qq.com/api/doc/90000/90135/92366
     */
    public MaterialInfo get(@NonNull String accessToken, @NonNull String templateId) throws WeworkException {
        String url = MessageFormat.format(getMaterialUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        Map<String, Object> params = new HashMap<>();
        params.put("template_id", templateId);
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<MaterialInfo> forEntity = restTemplate.postForEntity(url, httpEntity, MaterialInfo.class);

        MaterialInfo result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }

    /**
     * 删除入群欢迎语素材
     * 
     * @param accessToken
     * @param templateId 素材id
     * @link https://open.work.weixin.qq.com/api/doc/90000/90135/92366
     */
    @GenAsync
    public void delete(@NonNull String accessToken, @NonNull String templateId) throws WeworkException {
        String url = MessageFormat.format(delMaterialUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        Map<String, Object> params = new HashMap<>();
        params.put("template_id", templateId);
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<ErrorCode> forEntity = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);

        ErrorCode result = forEntity.getBody();
        WeworkException.isSuccess(result);
    }

}
