package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.externalpay.BillListResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/**
 * 企微商品图册支付记录
 * 
 */
@Component
public class WeworkPayApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    @Value("${qyapi.externalpay.get_bill_list}")
    private String billListUrl;

    public BillListResp getBillList(@NonNull String accessToken, @NonNull Long beginTime, @NonNull Long endTime,
                                    String cursor, Integer limit) throws WeworkException {
        String url = MessageFormat.format(billListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> params = new HashMap<>();
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        if (StringUtils.isNotBlank(cursor)) {
            params.put("cursor", cursor);
        }
        if (limit != null) {
            params.put("limit", limit);
        }
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(params, headers);
        ResponseEntity<BillListResp> forEntity = restTemplate.postForEntity(url, httpEntity, BillListResp.class);
        BillListResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }

}
