package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.miniprogram.Jscode2sessionResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;

/**
 * @author Created by lixiaobin on 2022/4/28
 */
@Slf4j
@Component
public class MiniprogramApi {

    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    @Value("${qyapi.jscode2session}")
    private String jscode2session;

    /**
     * code换取userId 信息
     *
     * @see https://developer.work.weixin.qq.com/document/path/91507
     * @param accessToken 接口调用凭证
     * @param code 小程序登录获取到的code
     * @return 用户明文 userId
     */
    public Jscode2sessionResp jscode2session(@NonNull String accessToken, @NonNull String code) throws WeworkException {
        // 发起请求
        String url = MessageFormat.format(jscode2session, accessToken, code);
        ResponseEntity<Jscode2sessionResp> response = restTemplate.getForEntity(url, Jscode2sessionResp.class);

        Jscode2sessionResp result = response.getBody();
        WeworkException.isSuccess(result);
        return result;
    }
}
