/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.license.setting.GetAutoActiveStatusDto;
import cn.kinyun.wework.sdk.entity.license.setting.GetAutoActiveStatusResp;
import cn.kinyun.wework.sdk.entity.license.setting.SetAutoActiveStatusReq;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class LicenseSettingApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.license.set_auto_active_status}")
    private String licenseSetAutoActiveStatusUrl;
    @Value(value="${qyapi.license.get_auto_active_status}")
    private String licenseGetAutoActiveStatusUrl;

    public void setAutoActiveStatus(@NonNull String accessToken, @NonNull SetAutoActiveStatusReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseSetAutoActiveStatusUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public GetAutoActiveStatusResp getAutoActiveStatus(@NonNull String accessToken, @NonNull String activeCorpId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (activeCorpId == null) {
            throw new NullPointerException("activeCorpId is marked non-null but is null");
        }
        GetAutoActiveStatusDto req = new GetAutoActiveStatusDto();
        req.setCorpId(activeCorpId);
        String url = MessageFormat.format(this.licenseGetAutoActiveStatusUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GetAutoActiveStatusResp.class, new Object[0]);
        GetAutoActiveStatusResp result = (GetAutoActiveStatusResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

