/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.license.app.GetAppLicenseInfoReq;
import cn.kinyun.wework.sdk.entity.license.app.GetAppLicenseInfoResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class LicenseAppApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.license.get_app_license_info}")
    private String licenseGetAppLicenseInfoUrl;

    public GetAppLicenseInfoResp getAppLicenseInfo(@NonNull String accessToken, @NonNull GetAppLicenseInfoReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseGetAppLicenseInfoUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GetAppLicenseInfoResp.class, new Object[0]);
        GetAppLicenseInfoResp result = (GetAppLicenseInfoResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

