/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.license.account.ActiveAccountReq;
import cn.kinyun.wework.sdk.entity.license.account.BatchActiveAccountReq;
import cn.kinyun.wework.sdk.entity.license.account.BatchActiveAccountResp;
import cn.kinyun.wework.sdk.entity.license.account.BatchGetActiveInfoByCodeReq;
import cn.kinyun.wework.sdk.entity.license.account.BatchGetActiveInfoByCodeResp;
import cn.kinyun.wework.sdk.entity.license.account.BatchShareActiveCodeReq;
import cn.kinyun.wework.sdk.entity.license.account.BatchShareActiveCodeResp;
import cn.kinyun.wework.sdk.entity.license.account.BatchTransferLicenseReq;
import cn.kinyun.wework.sdk.entity.license.account.BatchTransferLicenseResp;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByCodeReq;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByCodeResp;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByUserReq;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByUserResp;
import cn.kinyun.wework.sdk.entity.license.account.ListActivatedAccountReq;
import cn.kinyun.wework.sdk.entity.license.account.ListActivatedAccountResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class LicenseAccountApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.license.active_account}")
    private String licenseActiveAccountUrl;
    @Value(value="${qyapi.license.batch_active_account}")
    private String licenseBatchActiveAccountUrl;
    @Value(value="${qyapi.license.get_active_info_by_code}")
    private String licenseGetActiveInfoByCodeUrl;
    @Value(value="${qyapi.license.batch_get_active_info_by_code}")
    private String licenseBatchGetActiveInfoByCodeUrl;
    @Value(value="${qyapi.license.list_actived_account}")
    private String licenseListActivatedAccountUrl;
    @Value(value="${qyapi.license.get_active_info_by_user}")
    private String licenseGetActiveInfoByUserUrl;
    @Value(value="${qyapi.license.batch_transfer_license}")
    private String licenseBatchTransferUrl;
    @Value(value="${qyapi.license.batch_share_active_code}")
    private String licenseBatchShareActiveCodeUrl;

    public void activeAccount(@NonNull String accessToken, @NonNull ActiveAccountReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseActiveAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public BatchActiveAccountResp batchActiveAccount(@NonNull String accessToken, @NonNull BatchActiveAccountReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseBatchActiveAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BatchActiveAccountResp.class, new Object[0]);
        BatchActiveAccountResp result = (BatchActiveAccountResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public GetActiveInfoByCodeResp getActiveInfoByCode(@NonNull String accessToken, @NonNull GetActiveInfoByCodeReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseGetActiveInfoByCodeUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GetActiveInfoByCodeResp.class, new Object[0]);
        GetActiveInfoByCodeResp result = (GetActiveInfoByCodeResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public BatchGetActiveInfoByCodeResp batchGetActiveInfoByCode(@NonNull String accessToken, @NonNull BatchGetActiveInfoByCodeReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseGetActiveInfoByCodeUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BatchGetActiveInfoByCodeResp.class, new Object[0]);
        BatchGetActiveInfoByCodeResp result = (BatchGetActiveInfoByCodeResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public ListActivatedAccountResp listActivatedAccount(@NonNull String accessToken, @NonNull ListActivatedAccountReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseListActivatedAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ListActivatedAccountResp.class, new Object[0]);
        ListActivatedAccountResp result = (ListActivatedAccountResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public GetActiveInfoByUserResp getActiveInfoByUser(@NonNull String accessToken, @NonNull GetActiveInfoByUserReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseGetActiveInfoByUserUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GetActiveInfoByUserResp.class, new Object[0]);
        GetActiveInfoByUserResp result = (GetActiveInfoByUserResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public BatchTransferLicenseResp batchTransferLicense(@NonNull String accessToken, @NonNull BatchTransferLicenseReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseBatchTransferUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BatchTransferLicenseResp.class, new Object[0]);
        BatchTransferLicenseResp result = (BatchTransferLicenseResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public BatchShareActiveCodeResp batchShareActiveCode(@NonNull String accessToken, @NonNull BatchShareActiveCodeReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseBatchShareActiveCodeUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BatchShareActiveCodeResp.class, new Object[0]);
        BatchShareActiveCodeResp result = (BatchShareActiveCodeResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

