/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgListParams;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgListResp;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgParams;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgResp;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgTaskResult;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgUserTask;
import cn.kinyun.wework.sdk.entity.external.welcome.WelcomeMsg;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class MassMsgPushApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.msgpush.add_massmsg_push}")
    private String addMassMsgPushUrl;
    @Value(value="${qyapi.msgpush.get_massmsg_list}")
    private String getMassMsgListUrl;
    @Value(value="${qyapi.msgpush.get_user_massmsg_list}")
    private String getUserMassMsgListUrl;
    @Value(value="${qyapi.msgpush.get_user_massmsg_result}")
    private String getMassMsgResultUrl;
    @Value(value="${qyapi.msgpush.send_replymsg}")
    private String sendReplyMsgUrl;
    @Value(value="${qyapi.message.recall}")
    private String wwMessageRecall;

    @GenAsync
    public MassMsgResp massMsgSend(@NonNull String accessToken, @NonNull MassMsgParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.addMassMsgPushUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MassMsgResp.class, new Object[0]);
        MassMsgResp result = (MassMsgResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public MassMsgListResp getMassMsgList(@NonNull String accessToken, @NonNull MassMsgListParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getMassMsgListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MassMsgListResp.class, new Object[0]);
        MassMsgListResp result = (MassMsgListResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public MassMsgUserTask getMassMsgUserTask(@NonNull String accessToken, @NonNull String msgId, @GenNullable Integer limit, @GenNullable String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (msgId == null) {
            throw new NullPointerException("msgId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getUserMassMsgListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        if (limit == null) {
            limit = 50;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgid", msgId);
        params.put("limit", limit);
        params.put("cursor", cursor);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MassMsgUserTask.class, new Object[0]);
        MassMsgUserTask result = (MassMsgUserTask)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public MassMsgTaskResult getMassMsgTaskResult(@NonNull String accessToken, @NonNull String msgId, @NonNull String userId, @GenNullable Integer limit, @GenNullable String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (msgId == null) {
            throw new NullPointerException("msgId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getMassMsgResultUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        if (limit == null) {
            limit = 50;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgid", msgId);
        params.put("userid", userId);
        params.put("limit", limit);
        params.put("cursor", cursor);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MassMsgTaskResult.class, new Object[0]);
        MassMsgTaskResult result = (MassMsgTaskResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void sendWelcomeMsg(@NonNull String accessToken, @NonNull WelcomeMsg params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.sendReplyMsgUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    public ErrorCode recallMsg(@NonNull String accessToken, @NonNull String msgId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (msgId == null) {
            throw new NullPointerException("msgId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwMessageRecall, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("msgid", msgId);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

