/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.AddMaterialParams;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.MaterialConfigResult;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.MaterialInfo;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.UpdateMaterialParams;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class JoinGroupMaterialApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.material.manager.add}")
    private String addMaterialUrl;
    @Value(value="${qyapi.material.manager.edit}")
    private String editMaterialUrl;
    @Value(value="${qyapi.material.manager.get}")
    private String getMaterialUrl;
    @Value(value="${qyapi.material.manager.del}")
    private String delMaterialUrl;

    @GenAsync
    public MaterialConfigResult add(@NonNull String accessToken, @NonNull AddMaterialParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.addMaterialUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MaterialConfigResult.class, new Object[0]);
        MaterialConfigResult result = (MaterialConfigResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void update(@NonNull String accessToken, @NonNull UpdateMaterialParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.editMaterialUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public MaterialInfo get(@NonNull String accessToken, @NonNull String templateId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (templateId == null) {
            throw new NullPointerException("templateId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getMaterialUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("template_id", templateId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MaterialInfo.class, new Object[0]);
        MaterialInfo result = (MaterialInfo)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void delete(@NonNull String accessToken, @NonNull String templateId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (templateId == null) {
            throw new NullPointerException("templateId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.delMaterialUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("template_id", templateId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }
}

