/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.annotation.GenLock;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.annotation.GenRetry;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.croptag.AddCorpTagParams;
import cn.kinyun.wework.sdk.entity.external.croptag.AddCorpTagResp;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTagGroup;
import cn.kinyun.wework.sdk.entity.external.croptag.CorpTagList;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import cn.kinyun.wework.sdk.entity.external.croptag.UpdateCorpTagParams;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ExternalTagApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.get_corp_tag_list}")
    private String corpTagListUrl;
    @Value(value="${qyapi.externalcontact.add_corp_tag}")
    private String addCorpTagUrl;
    @Value(value="${qyapi.externalcontact.edit_corp_tag}")
    private String editCorpTagUrl;
    @Value(value="${qyapi.externalcontact.del_corp_tag}")
    private String delCorpTagUrl;
    @Value(value="${qyapi.externalcontact.mark_tag}")
    private String markTagUrl;

    public List<CorpTagGroup> list(@NonNull String accessToken, @GenNullable Collection<String> groupIds, @GenNullable Collection<String> tagIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.corpTagListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        params.put("group_id", groupIds);
        params.put("tag_id", tagIds);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CorpTagList.class, new Object[0]);
        CorpTagList result = (CorpTagList)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getTagGroupList();
    }

    @GenAsync
    public AddCorpTagResp add(@NonNull String accessToken, @NonNull AddCorpTagParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.addCorpTagUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, AddCorpTagResp.class, new Object[0]);
        AddCorpTagResp result = (AddCorpTagResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void update(@NonNull String accessToken, @NonNull UpdateCorpTagParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.editCorpTagUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    public void delete(@NonNull String accessToken, @GenNullable Collection<String> groupIds, @GenNullable Collection<String> tagIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.delCorpTagUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        params.put("group_id", groupIds);
        params.put("tag_id", tagIds);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    @GenRetry
    @GenLock(value="\"ExternalTagClient:markTag:\" + corpId")
    public void markTag(@NonNull String accessToken, @NonNull MarkTagParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.markTagUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }
}

