/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.annotation.GenLock;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.annotation.GenRetry;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactDetailList;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactList;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactRemark;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactResp;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalPendingIdResp;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalUserIdResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import cn.kinyun.wework.sdk.utils.JacksonUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ExternalContactApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.list}")
    private String extContactListUrl;
    @Value(value="${qyapi.externalcontact.get}")
    private String externalContactDetailUrl;
    @Value(value="${qyapi.externalcontact.batch_get_by_user}")
    private String externalContactDetailListUrl;
    @Value(value="${qyapi.externalcontact.remark}")
    private String externalContactRemarkUrl;
    @Value(value="${qyapi.externalcontact.unionid_to_external_userid}")
    private String unionidToExternalUserIdUrl;
    @Value(value="${qyapi.externalcontact.unionid_convert}")
    private String unionidConvertUrl;
    @Value(value="${qyapi.externalcontact.external_userid_get_pendingid}")
    private String userIdGetPendingIdUrl;

    public List<String> list(@NonNull String accessToken, @NonNull String userId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.extContactListUrl, accessToken, userId);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, ExternalContactList.class, new Object[0]);
        ExternalContactList result = (ExternalContactList)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getExternalUserList();
    }

    public ExternalContactResp getDetail(@NonNull String accessToken, @NonNull String externalUserId, @GenNullable String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (externalUserId == null) {
            throw new NullPointerException("externalUserId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.externalContactDetailUrl, accessToken, externalUserId);
        if (cursor != null) {
            url = url + "&cursor=" + cursor;
        }
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)forEntity.getBody();
        ExternalContactResp result = null;
        try {
            result = JacksonUtils.readValue(body, ExternalContactResp.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public ExternalContactDetailList getDetailList(@NonNull String accessToken, @NonNull String userId, @GenNullable String cursor, @GenNullable Integer limit) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.externalContactDetailListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userId);
        if (cursor != null) {
            params.put("cursor", cursor);
        }
        if (limit != null) {
            params.put("limit", limit);
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        String body = (String)forEntity.getBody();
        ExternalContactDetailList result = null;
        try {
            result = JacksonUtils.readValue(body, ExternalContactDetailList.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    @GenRetry
    @GenLock(value="\"ExternalContactClient:remark:\" + corpId ")
    public void remark(@NonNull String accessToken, @NonNull ExternalContactRemark remark) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (remark == null) {
            throw new NullPointerException("remark is marked non-null but is null");
        }
        if (remark.getRemarkMobiles() != null && remark.getRemarkMobiles().isEmpty()) {
            remark.setRemarkMobiles(Collections.singletonList(""));
        }
        String url = MessageFormat.format(this.externalContactRemarkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)remark, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenLock
    public String unionIdToExternalUserId(@NonNull String accessToken, @NonNull String unionId, @NonNull String openId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (unionId == null) {
            throw new NullPointerException("unionId is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.unionidToExternalUserIdUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unionid", unionId);
        params.put("openid", openId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ExternalUserIdResp.class, new Object[0]);
        ExternalUserIdResp result = (ExternalUserIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getExternalUserId();
    }

    @GenLock
    public ExternalUserIdResp unionIdConvert(@NonNull String accessToken, @NonNull String unionId, @NonNull String openId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (unionId == null) {
            throw new NullPointerException("unionId is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.unionidConvertUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unionid", unionId);
        params.put("openid", openId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ExternalUserIdResp.class, new Object[0]);
        ExternalUserIdResp result = (ExternalUserIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenLock
    public ExternalPendingIdResp userIdGetPendingId(@NonNull String accessToken, @NonNull List<String> externalUserIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (externalUserIds == null) {
            throw new NullPointerException("externalUserIds is marked non-null but is null");
        }
        String url = MessageFormat.format(this.unionidConvertUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("external_userid", externalUserIds);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ExternalPendingIdResp.class, new Object[0]);
        ExternalPendingIdResp result = (ExternalPendingIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

