/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.groupchat.ChatDetailInfo;
import cn.kinyun.wework.sdk.entity.external.groupchat.ExternalGroupChatDetailResp;
import cn.kinyun.wework.sdk.entity.external.groupchat.ExternalGroupChatListResp;
import cn.kinyun.wework.sdk.enums.ChatStatusFilter;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ExternalChatApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.groupchat_list}")
    private String groupChatListUrl;
    @Value(value="${qyapi.externalcontact.groupchat_get}")
    private String groupChatDetailUrl;

    public ExternalGroupChatListResp list(@NonNull String accessToken, @GenNullable ChatStatusFilter statusFilter, @GenNullable List<String> userIds, @GenNullable String cursor, @NonNull Integer limit) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        String url = MessageFormat.format(this.groupChatListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (statusFilter != null) {
            params.put("status_filter", statusFilter.getValue());
        }
        if (userIds != null && !userIds.isEmpty()) {
            HashMap<String, List<String>> ownerFilter = new HashMap<String, List<String>>();
            ownerFilter.put("userid_list", userIds);
            params.put("owner_filter", ownerFilter);
        }
        if (cursor != null) {
            params.put("cursor", cursor);
        }
        params.put("limit", limit);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ExternalGroupChatListResp.class, new Object[0]);
        ExternalGroupChatListResp result = (ExternalGroupChatListResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public ChatDetailInfo detail(@NonNull String accessToken, @NonNull String chatId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.groupChatDetailUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chat_id", chatId);
        params.put("need_name", 1);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ExternalGroupChatDetailResp.class, new Object[0]);
        ExternalGroupChatDetailResp result = (ExternalGroupChatDetailResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getGroupChat();
    }
}

