/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.chat;

import cn.kinyun.wework.sdk.api.chat.ChatApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ChatApiFactory {
    public static final Map<String, ChatApi> MAP = new HashMap<String, ChatApi>();

    public static ChatApi get(String corpId) {
        return MAP.get(corpId);
    }

    public static void put(ChatApi api) {
        String corpId = api.getCorpId();
        ChatApiFactory.destroy(corpId);
        MAP.put(corpId, api);
    }

    public static Collection<ChatApi> getAll() {
        return MAP.values();
    }

    public static void destroy(String corpId) {
        ChatApi exists = MAP.remove(corpId);
        if (exists != null) {
            exists.destroySdk();
        }
    }

    public static void destroyAll() {
        Iterator<Map.Entry<String, ChatApi>> it = MAP.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ChatApi> e = it.next();
            e.getValue().destroySdk();
            it.remove();
        }
    }

    public void setProxy(String proxy) {
        for (Map.Entry<String, ChatApi> e : MAP.entrySet()) {
            e.getValue().setProxy(proxy);
        }
    }

    public void setPasswd(String passwd) {
        for (Map.Entry<String, ChatApi> e : MAP.entrySet()) {
            e.getValue().setPasswd(passwd);
        }
    }

    public void setTimeout(int timeout) {
        for (Map.Entry<String, ChatApi> e : MAP.entrySet()) {
            e.getValue().setTimeout(timeout);
        }
    }
}

