/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.chat;

import cn.kinyun.wework.sdk.api.chat.ChatApi;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ChatApiBuilder {
    private String corpId;
    private String secret;
    private String proxy;
    private String passwd;
    private int timeout = 5;
    private Map<String, String> privateKeyMap = new HashMap<String, String>();

    public ChatApiBuilder corpId(String corpId) {
        this.corpId = corpId;
        return this;
    }

    public ChatApiBuilder secret(String secret) {
        this.secret = secret;
        return this;
    }

    public ChatApiBuilder proxy(String proxy) {
        this.proxy = proxy;
        return this;
    }

    public ChatApiBuilder passwd(String passwd) {
        this.passwd = passwd;
        return this;
    }

    public ChatApiBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ChatApiBuilder addPrikey(String version, String privateKey) {
        this.privateKeyMap.put(version, privateKey);
        return this;
    }

    public ChatApi build() throws IOException {
        ChatApi api = new ChatApi(this.corpId, this.secret);
        api.setProxy(this.proxy);
        api.setPasswd(this.passwd);
        api.setTimeout(this.timeout);
        for (Map.Entry<String, String> e : this.privateKeyMap.entrySet()) {
            String version = e.getKey();
            String privateKey = e.getValue();
            api.addPrivateKey(version, privateKey);
        }
        return api;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Map<String, String> getPrivateKeyMap() {
        return this.privateKeyMap;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setPrivateKeyMap(Map<String, String> privateKeyMap) {
        this.privateKeyMap = privateKeyMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatApiBuilder)) {
            return false;
        }
        ChatApiBuilder other = (ChatApiBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        String this$passwd = this.getPasswd();
        String other$passwd = other.getPasswd();
        if (this$passwd == null ? other$passwd != null : !this$passwd.equals(other$passwd)) {
            return false;
        }
        Map<String, String> this$privateKeyMap = this.getPrivateKeyMap();
        Map<String, String> other$privateKeyMap = other.getPrivateKeyMap();
        return !(this$privateKeyMap == null ? other$privateKeyMap != null : !((Object)this$privateKeyMap).equals(other$privateKeyMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatApiBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeout();
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        String $passwd = this.getPasswd();
        result = result * 59 + ($passwd == null ? 43 : $passwd.hashCode());
        Map<String, String> $privateKeyMap = this.getPrivateKeyMap();
        result = result * 59 + ($privateKeyMap == null ? 43 : ((Object)$privateKeyMap).hashCode());
        return result;
    }

    public String toString() {
        return "ChatApiBuilder(corpId=" + this.getCorpId() + ", secret=" + this.getSecret() + ", proxy=" + this.getProxy() + ", passwd=" + this.getPasswd() + ", timeout=" + this.getTimeout() + ", privateKeyMap=" + this.getPrivateKeyMap() + ")";
    }
}

