/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.suite.AdminList;
import cn.kinyun.wework.sdk.entity.suite.AuthInfo;
import cn.kinyun.wework.sdk.entity.suite.CorpToken;
import cn.kinyun.wework.sdk.entity.suite.PermanentCode;
import cn.kinyun.wework.sdk.entity.suite.PreAuthCode;
import cn.kinyun.wework.sdk.entity.suite.SuiteToken;
import cn.kinyun.wework.sdk.enums.SuiteAuthType;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SuiteApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.suite.install}")
    private String wwInstallUrl;
    @Value(value="${qyapi.suite.get_suite_token}")
    private String wwGetSuiteToken;
    @Value(value="${qyapi.suite.get_pre_auth_code}")
    private String wwGetPreAuthCode;
    @Value(value="${qyapi.suite.set_session_info}")
    private String wwSetSessionInfo;
    @Value(value="${qyapi.suite.get_permanent_code}")
    private String wwGetPermanentCode;
    @Value(value="${qyapi.suite.get_auth_info}")
    private String wwGetAuthInfo;
    @Value(value="${qyapi.suite.get_corp_token}")
    private String wwGetCorpToken;
    @Value(value="${qyapi.suite.get_admin_list}")
    private String wwGetAdminList;

    @GenIgnore
    public String getInstallUrl(@NonNull String suiteId, @NonNull String preAuthCode, @NonNull String redirectUri, @GenNullable String state) {
        if (suiteId == null) {
            throw new NullPointerException("suiteId is marked non-null but is null");
        }
        if (preAuthCode == null) {
            throw new NullPointerException("preAuthCode is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        return MessageFormat.format(this.wwInstallUrl, suiteId, preAuthCode, redirectUri, state);
    }

    @GenIgnore
    public SuiteToken getSuiteToken(@NonNull String suiteId, @NonNull String suiteSecret, @NonNull String suiteTicket) throws WeworkException {
        if (suiteId == null) {
            throw new NullPointerException("suiteId is marked non-null but is null");
        }
        if (suiteSecret == null) {
            throw new NullPointerException("suiteSecret is marked non-null but is null");
        }
        if (suiteTicket == null) {
            throw new NullPointerException("suiteTicket is marked non-null but is null");
        }
        String url = this.wwGetSuiteToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("suite_id", suiteId);
        params.put("suite_secret", suiteSecret);
        params.put("suite_ticket", suiteTicket);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, SuiteToken.class, new Object[0]);
        SuiteToken result = (SuiteToken)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenIgnore
    public PreAuthCode getPreAuthCode(@NonNull String suiteAccessToken) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetPreAuthCode, suiteAccessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, PreAuthCode.class, new Object[0]);
        PreAuthCode result = (PreAuthCode)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenIgnore
    public void setSessionInfo(@NonNull String suiteAccessToken, @NonNull String preAuthCode, @GenNullable SuiteAuthType authType) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (preAuthCode == null) {
            throw new NullPointerException("preAuthCode is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwSetSessionInfo, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap sessionInfo = Maps.newHashMap();
        if (authType != null) {
            sessionInfo.put("auth_type", authType.getValue());
        }
        HashMap params = Maps.newHashMap();
        params.put("pre_auth_code", preAuthCode);
        params.put("session_info", sessionInfo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenIgnore
    public void setSessionInfo(@NonNull String suiteAccessToken, @NonNull String preAuthCode, @GenNullable SuiteAuthType authType, String ... appids) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (preAuthCode == null) {
            throw new NullPointerException("preAuthCode is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwSetSessionInfo, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap sessionInfo = Maps.newHashMap();
        if (authType != null) {
            sessionInfo.put("auth_type", authType.getValue());
        }
        if (appids != null) {
            sessionInfo.put("appid", appids);
        }
        HashMap params = Maps.newHashMap();
        params.put("pre_auth_code", preAuthCode);
        params.put("session_info", sessionInfo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenIgnore
    public PermanentCode getPermanentCode(@NonNull String suiteAccessToken, @NonNull String authCode) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (authCode == null) {
            throw new NullPointerException("authCode is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetPermanentCode, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("auth_code", authCode);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, PermanentCode.class, new Object[0]);
        PermanentCode result = (PermanentCode)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenIgnore
    public AuthInfo getAuthInfo(@NonNull String suiteAccessToken, @NonNull String autoCorpId, @NonNull String permanentCode) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (autoCorpId == null) {
            throw new NullPointerException("autoCorpId is marked non-null but is null");
        }
        if (permanentCode == null) {
            throw new NullPointerException("permanentCode is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetAuthInfo, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("auth_corpid", autoCorpId);
        params.put("permanent_code", permanentCode);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, AuthInfo.class, new Object[0]);
        AuthInfo result = (AuthInfo)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenIgnore
    public CorpToken getCorpToken(@NonNull String suiteAccessToken, @NonNull String authCorpId, @NonNull String permanentCode) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (authCorpId == null) {
            throw new NullPointerException("authCorpId is marked non-null but is null");
        }
        if (permanentCode == null) {
            throw new NullPointerException("permanentCode is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetCorpToken, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("auth_corpid", authCorpId);
        params.put("permanent_code", permanentCode);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, CorpToken.class, new Object[0]);
        CorpToken result = (CorpToken)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenIgnore
    public AdminList getAdminList(@NonNull String suiteAccessToken, @NonNull String autoCorpId, @NonNull String agentId) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (autoCorpId == null) {
            throw new NullPointerException("autoCorpId is marked non-null but is null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetAdminList, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("auth_corpid", autoCorpId);
        params.put("agentid", agentId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, AdminList.class, new Object[0]);
        AdminList result = (AdminList)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

