/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.provider.LoginInfo;
import cn.kinyun.wework.sdk.entity.provider.ProviderToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ProviderApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.service.get_provider_token}")
    private String wwGetProviderToken;
    @Value(value="${qyapi.service.get_login_info}")
    private String wwGetLoginInfo;

    @GenIgnore
    public ProviderToken getProviderToken(@NonNull String corpId, @NonNull String providerSecret) throws WeworkException {
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        if (providerSecret == null) {
            throw new NullPointerException("providerSecret is marked non-null but is null");
        }
        String url = this.wwGetProviderToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("corpid", corpId);
        params.put("provider_secret", providerSecret);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ProviderToken.class, new Object[0]);
        ProviderToken result = (ProviderToken)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenIgnore
    public LoginInfo getLoginInfo(@NonNull String providerAccessToken, @NonNull String authCode) throws WeworkException {
        if (providerAccessToken == null) {
            throw new NullPointerException("providerAccessToken is marked non-null but is null");
        }
        if (authCode == null) {
            throw new NullPointerException("authCode is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetLoginInfo, providerAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("auth_code", authCode);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, LoginInfo.class, new Object[0]);
        LoginInfo result = (LoginInfo)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

