/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.chat.ChatData;
import cn.kinyun.wework.sdk.entity.chat.MediaData;
import cn.kinyun.wework.sdk.entity.chat.PermitUserDto;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class FinanceApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.finance.getchatdata}")
    private String wwGetChatData;
    @Value(value="${qyapi.finance.getchatmediadata}")
    private String wwGetMediaData;
    @Value(value="${qyapi.finance.getPermitUserList}")
    private String getPermitUserList;

    public PermitUserDto getPermitUserList(@NonNull String accessToken, @GenNullable Integer type) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getPermitUserList, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        if (Objects.nonNull(type)) {
            params.put("type", type);
        }
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, PermitUserDto.class, new Object[0]);
        PermitUserDto result = (PermitUserDto)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public ChatData getChatData(@NonNull String accessToken, @NonNull Long seq, @NonNull Integer limit) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetChatData, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("seq", seq);
        params.put("limit", limit);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ChatData.class, new Object[0]);
        ChatData result = (ChatData)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public MediaData getMediaData(@NonNull String accessToken, @NonNull String fileId, @NonNull String authKey) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        if (authKey == null) {
            throw new NullPointerException("authKey is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetMediaData, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("fileid", fileId);
        params.put("authkey", authKey);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, MediaData.class, new Object[0]);
        MediaData result = (MediaData)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

