/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.custmized.CustomizedAuthUrl;
import cn.kinyun.wework.sdk.entity.custmized.OpenCorpId;
import cn.kinyun.wework.sdk.entity.custmized.OpenExternalUserIds;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserId;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserIds;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CustomizedApi {
    private static final Logger log = LoggerFactory.getLogger(CustomizedApi.class);
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.service.get_customized_auth_url}")
    private String getCustomizedAuthUrl;
    @Value(value="${qyapi.service.corpid_to_opencorpid}")
    private String toOpenCorpId;
    @Value(value="${qyapi.service.userid_to_openuserid}")
    private String toOpenUserId;
    @Value(value="${qyapi.externalcontact.get_new_external_userid}")
    private String getNewExternalUserId;
    @Value(value="${qyapi.externalcontact.groupchat.get_new_external_userid}")
    private String getNewChatExternalUserId;
    @Value(value="${qyapi.service.finish_openid_migration}")
    private String finishOpenidMigration;

    public CustomizedAuthUrl getCustomizedAuthUrl(@NonNull String providerAccessToken, @NonNull List<String> templateIds, @GenNullable String state) throws WeworkException {
        if (providerAccessToken == null) {
            throw new NullPointerException("providerAccessToken is marked non-null but is null");
        }
        if (templateIds == null) {
            throw new NullPointerException("templateIds is marked non-null but is null");
        }
        log.info("get customized auth url, templateIds={}, state={}", templateIds, (Object)state);
        String url = MessageFormat.format(this.getCustomizedAuthUrl, providerAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("templateid_list", templateIds);
        if (state != null) {
            params.put("state", state);
        }
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, CustomizedAuthUrl.class, new Object[0]);
        CustomizedAuthUrl result = (CustomizedAuthUrl)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public String getOpenCorpId(@NonNull String providerAccessToken, @NonNull String corpId) throws WeworkException {
        if (providerAccessToken == null) {
            throw new NullPointerException("providerAccessToken is marked non-null but is null");
        }
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        log.info("get open corpId={}", (Object)corpId);
        String url = MessageFormat.format(this.toOpenCorpId, providerAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("corpid", corpId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, OpenCorpId.class, new Object[0]);
        OpenCorpId result = (OpenCorpId)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        log.info("get open corpId, {} --> {}", (Object)corpId, (Object)result.getOpenCorpId());
        return result.getOpenCorpId();
    }

    public OpenUserIds getOpenUserIds(@NonNull String accessToken, @NonNull List<String> userIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userIds == null) {
            throw new NullPointerException("userIds is marked non-null but is null");
        }
        String url = MessageFormat.format(this.toOpenUserId, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("userid_list", userIds);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, OpenUserIds.class, new Object[0]);
        OpenUserIds result = (OpenUserIds)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public Map<String, String> getOpenUserIdMap(@NonNull String accessToken, @NonNull List<String> userIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userIds == null) {
            throw new NullPointerException("userIds is marked non-null but is null");
        }
        log.info("get open userId map, userIds={}", userIds);
        OpenUserIds result = this.getOpenUserIds(accessToken, userIds);
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (result.getOpenUserIdList() == null || result.getOpenUserIdList().size() == 0) {
            log.warn("open user id list is empty.");
            return idMap;
        }
        for (OpenUserId it : result.getOpenUserIdList()) {
            idMap.put(it.getUserId(), it.getOpenUserId());
        }
        return idMap;
    }

    public String getOpenUserId(@NonNull String accessToken, @NonNull String userId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        log.info("get open userId, userId={}", (Object)userId);
        OpenUserIds result = this.getOpenUserIds(accessToken, Collections.singletonList(userId));
        if (result.getOpenUserIdList() == null || result.getOpenUserIdList().size() == 0) {
            log.warn("open user id list is empty");
            return null;
        }
        return ((OpenUserId)result.getOpenUserIdList().get(0)).getOpenUserId();
    }

    public OpenExternalUserIds getNewExternalUserId(@NonNull String accessToken, @NonNull List<String> externalUserIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (externalUserIds == null) {
            throw new NullPointerException("externalUserIds is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getNewExternalUserId, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("external_userid_list", externalUserIds);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, OpenExternalUserIds.class, new Object[0]);
        OpenExternalUserIds result = (OpenExternalUserIds)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public OpenExternalUserIds getNewChatExternalUserId(@NonNull String accessToken, @NonNull String chatId, @NonNull List<String> externalUserIds) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (externalUserIds == null) {
            throw new NullPointerException("externalUserIds is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getNewChatExternalUserId, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("chat_id", chatId);
        params.put("external_userid_list", externalUserIds);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, OpenExternalUserIds.class, new Object[0]);
        OpenExternalUserIds result = (OpenExternalUserIds)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public void finishOpenidMigration(@NonNull String providerAccessToken, @NonNull String corpId, @NonNull Integer agentId, @NonNull List<Integer> openidTypes) throws WeworkException {
        if (providerAccessToken == null) {
            throw new NullPointerException("providerAccessToken is marked non-null but is null");
        }
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId is marked non-null but is null");
        }
        if (openidTypes == null) {
            throw new NullPointerException("openidTypes is marked non-null but is null");
        }
        String url = MessageFormat.format(this.finishOpenidMigration, providerAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("corpid", corpId);
        params.put("agentid", agentId);
        params.put("openid_type", openidTypes);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }
}

