/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@GenIgnore
public class AccessTokenApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.get_token}")
    private String getAccessTokenUrl;

    public AccessToken getAccessToken(@NonNull String corpId, @NonNull String corpSecret) throws WeworkException {
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        if (corpSecret == null) {
            throw new NullPointerException("corpSecret is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getAccessTokenUrl, corpId, corpSecret);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, AccessToken.class, new Object[0]);
        AccessToken result = (AccessToken)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

