package cn.kinyun.wework.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * @title XmlUtils
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 */
@Slf4j
public final class XmlUtils {

    private XmlUtils() {}

    private static final XmlMapper XML_MAPPER = new XmlMapper();

    static {
        XML_MAPPER.setSerializationInclusion(Include.NON_NULL);// 属性为NULL 不序列化
        XML_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);// 忽略未知属性
    }

    /**
     * 将对象序列化为xml
     * 
     * @param value
     * @return
     */
    public static String obj2Xml(Object value) {
        try {
            return XML_MAPPER.writeValueAsString(value);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error("Generate xml failed, obj={}", value, e);
        }

        return null;
    }

    /**
     * 将xml反序列化为对象
     * 
     * @param content
     * @param valueType
     * @return
     */
    public static <T> T xml2Obj(String content, Class<T> valueType) {
        try {
            return XML_MAPPER.readValue(content, valueType);
        } catch (IOException e) {
            e.printStackTrace();
            log.error("Parse xml failed, content={}", content, e);
        }

        return null;
    }
}
