package cn.kinyun.wework.sdk.utils;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;

import java.io.StringWriter;
import java.security.*;

/**
 * @author zhangjing
 * @date 2021/4/28 11:14 上午
 */
public final class RSAGenerator {

    private RSAGenerator() {}

    public static Pair<String, String> getNewRSAPairWithPKCS8(int keySize) {
        try {
            Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();

            String publicKey = getPEMString(keyPair.getPublic());

            String privateKey = getPEMPrivateString(keyPair.getPrivate());
            return new ImmutablePair<>(publicKey, privateKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 返回PKCS8格式的私钥
     * @param key
     * @return
     */
    private static String getPEMPrivateString(PrivateKey key) {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter(writer);
        try {
            pemWriter.writeObject(new JcaPKCS8Generator(key, null));
            pemWriter.close();
            writer.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    private static String getPEMString(Key key) {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter(writer);
        try {
            pemWriter.writeObject(key);
            pemWriter.close();
            writer.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

}
