package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.license.setting.GetAutoActiveStatusDto;
import cn.kinyun.wework.sdk.entity.license.setting.GetAutoActiveStatusResp;
import cn.kinyun.wework.sdk.entity.license.setting.SetAutoActiveStatusReq;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import java.text.MessageFormat;

/**
 * @author: lwl
 * @date: 2023/5/15
 * @description: 接口调用许可 -- 自动激活设置
 *
 * @link https://developer.work.weixin.qq.com/document/path/95873
 **/
@Component
public class LicenseSettingApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 设置企业的许可自动激活状态
     */
    @Value("${qyapi.license.set_auto_active_status}")
    private String licenseSetAutoActiveStatusUrl;

    /**
     * 设置企业的许可自动激活状态
     */
    @Value("${qyapi.license.get_auto_active_status}")
    private String licenseGetAutoActiveStatusUrl;

    /**
     * 设置企业的许可自动激活状态
     *
     * @link https://developer.work.weixin.qq.com/document/path/95873
     */
    public void setAutoActiveStatus(@NonNull String accessToken, @NonNull SetAutoActiveStatusReq req) throws WeworkException {
        String url = MessageFormat.format(licenseSetAutoActiveStatusUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<SetAutoActiveStatusReq> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<ErrorCode> forEntity = restTemplate.postForEntity(url, httpEntity, ErrorCode.class);
        ErrorCode result = forEntity.getBody();
        WeworkException.isSuccess(result);
    }

    /**
     * 获取企业的许可自动激活状态
     *
     * @link https://developer.work.weixin.qq.com/document/path/95874
     */
    public GetAutoActiveStatusResp getAutoActiveStatus(@NonNull String accessToken, @NonNull String activeCorpId) throws WeworkException {
        GetAutoActiveStatusDto req = new GetAutoActiveStatusDto();
        req.setCorpId(activeCorpId);

        String url = MessageFormat.format(licenseGetAutoActiveStatusUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<GetAutoActiveStatusDto> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<GetAutoActiveStatusResp> forEntity = restTemplate.postForEntity(url, httpEntity, GetAutoActiveStatusResp.class);
        GetAutoActiveStatusResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }
}
