package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.license.app.GetAppLicenseInfoReq;
import cn.kinyun.wework.sdk.entity.license.app.GetAppLicenseInfoResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import java.text.MessageFormat;

/**
 * @author: lwl
 * @date: 2023/5/15
 * @description: 接口调用许可 -- 应用管理
 *
 * @link https://developer.work.weixin.qq.com/document/path/95844
 **/
@Component

public class LicenseAppApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 获取应用的接口许可状态
     */
    @Value("${qyapi.license.get_app_license_info}")
    private String licenseGetAppLicenseInfoUrl;

    /**
     * 获取应用的接口许可状态
     *
     * @link https://developer.work.weixin.qq.com/document/path/95844
     **/
    public GetAppLicenseInfoResp getAppLicenseInfo(@NonNull String accessToken, @NonNull GetAppLicenseInfoReq req) throws WeworkException {
        String url = MessageFormat.format(licenseGetAppLicenseInfoUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<GetAppLicenseInfoReq> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<GetAppLicenseInfoResp> forEntity = restTemplate.postForEntity(url, httpEntity, GetAppLicenseInfoResp.class);
        GetAppLicenseInfoResp result = forEntity.getBody();
        WeworkException.isSuccess(result);
        return result;
    }
}
