package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.statistic.*;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.List;

/**
 * 客户统计管理api
 */
@Component
public class ExternalStatisticApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 获取客户列表url
     */
    @Value("${qyapi.statistic.get_user_behavior_data}")
    private String getUserBehaviorDataUrl;

    @Value("${qyapi.statistic.group_by_creator}")
    private String statisticGroupByCreatorUrl;

    /**
     * 获取「联系客户统计」数据
     *
     * @param accessToken
     * @link https://work.weixin.qq.com/api/doc/90000/90135/92132
     */
    public List<BehaviorData> getUserBehaviorData(@NonNull String accessToken, @NonNull UserBehaviorParams userBehaviorParams) throws WeworkException {
        String url = MessageFormat.format(getUserBehaviorDataUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<UserBehaviorParams> httpEntity = new HttpEntity<>(userBehaviorParams, headers);

        ResponseEntity<UserBehaviorData> forEntity = restTemplate.postForEntity(url, httpEntity, UserBehaviorData.class);

        UserBehaviorData result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result.getBehaviorDatas();
    }

    public GroupStatisticResult getGroupStatisticData(@NonNull String accessToken, @NonNull GroupChatStatisticParam groupChatStatisticParam) throws WeworkException {
        String url = MessageFormat.format(statisticGroupByCreatorUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<GroupChatStatisticParam> httpEntity = new HttpEntity<>(groupChatStatisticParam, headers);

        ResponseEntity<GroupStatisticResult> forEntity = restTemplate.postForEntity(url, httpEntity, GroupStatisticResult.class);

        GroupStatisticResult result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }
}
