/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.chat;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @title ChatApiFactory
 * @author yanmaoyuan
 * @date 2021年3月19日
 * @version 1.0
 */
public class ChatApiFactory {

    public static final Map<String, ChatApi> MAP = new HashMap<>();

    /**
     * 根据企业ID，查询ChatApi
     * 
     * @param corpId
     * @return
     */
    public static ChatApi get(String corpId) {
        return MAP.get(corpId);
    }

    /**
     * 添加一个ChatApi。如果corpId对应的ChatApi已存在，会先销毁旧的ChatApi。
     * 
     * @param api
     */
    public static void put(ChatApi api) {
        String corpId = api.getCorpId();
        destroy(corpId);

        MAP.put(corpId, api);
    }

    /**
     * 获取所有ChatApi
     * 
     * @return
     */
    public static Collection<ChatApi> getAll() {
        return MAP.values();
    }

    /**
     * 销毁指定企业corpId的ChatApi
     * 
     * @param corpId
     */
    public static void destroy(String corpId) {
        ChatApi exists = MAP.remove(corpId);
        if (exists != null) {
            exists.destroySdk();
        }
    }

    /**
     * 销毁所有ChatApi
     */
    public static void destroyAll() {
        Iterator<Entry<String, ChatApi>> it = MAP.entrySet().iterator();
        while (it.hasNext()) {
            Entry<String, ChatApi> e = it.next();
            e.getValue().destroySdk();
            it.remove();
        }
    }

    /**
     * 批量设置代理，需要传入代理的链接。如：socks5://10.0.0.1:8081 或者 http://10.0.0.1:8081
     * @param proxy
     */
    public void setProxy(String proxy) {
        Iterator<Entry<String, ChatApi>> it = MAP.entrySet().iterator();
        while (it.hasNext()) {
            Entry<String, ChatApi> e = it.next();
            e.getValue().setProxy(proxy);
        }
    }

    /**
     * 批量设置代理账号密码，需要传入代理的账号密码。如 user_name:passwd_123
     * 
     * @param passwd
     */
    public void setPasswd(String passwd) {
        Iterator<Entry<String, ChatApi>> it = MAP.entrySet().iterator();
        while (it.hasNext()) {
            Entry<String, ChatApi> e = it.next();
            e.getValue().setPasswd(passwd);
        }
    }

    /**
     * 批量设置超时时间，单位秒
     * 
     * @param timeout
     */
    public void setTimeout(int timeout) {
        Iterator<Entry<String, ChatApi>> it = MAP.entrySet().iterator();
        while (it.hasNext()) {
            Entry<String, ChatApi> e = it.next();
            e.getValue().setTimeout(timeout);
        }
    }
}