/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.chat;

import lombok.Data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @title ChatApiBuilder
 * @author yanmaoyuan
 * @date 2021年3月19日
 * @version 1.0
 */
@Data
public class ChatApiBuilder {
    
    private String corpId;

    private String secret;

    private String proxy;

    private String passwd;

    private int timeout = 5;

    /**
     * 以版本号为索引，记录不同版本的RSA私钥。
     */
    private Map<String, String> privateKeyMap = new HashMap<>();

    public ChatApiBuilder corpId(String corpId) {
        this.corpId = corpId;
        return this;
    }

    public ChatApiBuilder secret(String secret) {
        this.secret = secret;
        return this;
    }

    public ChatApiBuilder proxy(String proxy) {
        this.proxy = proxy;
        return this;
    }

    public ChatApiBuilder passwd(String passwd) {
        this.passwd = passwd;
        return this;
    }

    public ChatApiBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ChatApiBuilder addPrikey(String version, String privateKey) {
        this.privateKeyMap.put(version, privateKey);
        return this;
    }

    public ChatApi build() throws IOException {
        ChatApi api = new ChatApi(corpId, secret);

        api.setProxy(proxy);
        api.setPasswd(passwd);
        api.setTimeout(timeout);

        for (Map.Entry<String, String> e : privateKeyMap.entrySet()) {
            String version = e.getKey();
            String privateKey = e.getValue();
            api.addPrivateKey(version,privateKey);
        }

        return api;
    }
}