package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.api.req.ApplyEventReq;
import cn.kinyun.wework.sdk.api.req.ApproveDetailReq;
import cn.kinyun.wework.sdk.api.req.OaTemplateDetailReq;
import cn.kinyun.wework.sdk.entity.oa.ApplyEventResp;
import cn.kinyun.wework.sdk.entity.oa.ApproveDetailResp;
import cn.kinyun.wework.sdk.entity.oa.TemplateDetailResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;

/**
 * @author sunwen
 * OA 审批
 */
@Component
public class OaApi {

    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 获取审批模板详情
     */
    @Value("${qyapi.oa.templatedetail}")
    private String templateDetail;

    /**
     * 提交审批申请
     */
    @Value("${qyapi.oa.applyevent}")
    private String applyEvent;

    /**
     * 获取审批申请详情
     */
    @Value("${qyapi.oa.approvedetail}")
    private String approveDetail;

    public TemplateDetailResp templateDetail(@NonNull String accessToken, @NonNull OaTemplateDetailReq params) throws WeworkException {
        String url = MessageFormat.format(templateDetail, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<OaTemplateDetailReq> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<TemplateDetailResp> forEntity = restTemplate.postForEntity(url, httpEntity, TemplateDetailResp.class);

        TemplateDetailResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }

    public ApplyEventResp applyEvent(@NonNull String accessToken, @NonNull ApplyEventReq params) throws WeworkException {
        String url = MessageFormat.format(applyEvent, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<ApplyEventReq> httpEntity = new HttpEntity<>(params, headers);
        ResponseEntity<ApplyEventResp> forEntity = restTemplate.postForEntity(url, httpEntity, ApplyEventResp.class);

        ApplyEventResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }

    public ApproveDetailResp approveDetail(@NonNull String accessToken, @NonNull ApproveDetailReq params) throws WeworkException {
        String url = MessageFormat.format(approveDetail, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<ApproveDetailReq> httpEntity = new HttpEntity<>(params, headers);
        ResponseEntity<ApproveDetailResp> forEntity = restTemplate.postForEntity(url, httpEntity, ApproveDetailResp.class);

        ApproveDetailResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }
}
