package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.corpcontext.*;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.List;

/**
 * author: jw
 * date: 2022/6/8 下午1:42
 * content:
 */
@Component
@GenIgnore
public class CorpContextApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 获取共享应用信息
     */
    @Value("${qyapi.corp.group.share_app_info}")
    private String shareAppInfoUrl;

    /**
     * 获取下游企业的accessToken
     */
    @Value("${qyapi.corp.group.downstream.access_token}")
    private String downstreamAccessTokenUrl;

    /**
     * 通过unionid和openid查询下游企业的external_userid
     */
    @Value("${qyapi.corp.group.external_userid}")
    private String downstreamExternalUserIdUrl;


    /**
     * 获取共享应用信息
     * @param accessToken
     * @param corpId
     * @param agentId
     * @return
     */
    public List<CorpShareApp> getShareAppInfo(@NonNull String accessToken, String corpId, @NonNull Integer agentId) throws WeworkException {
        String url = MessageFormat.format(shareAppInfoUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        ShareAppReq req = new ShareAppReq();
        req.setCorpId(corpId);
        req.setAgentId(agentId);
        req.setBusinessType(1);
        HttpEntity<ShareAppReq> httpEntity = new HttpEntity<>(req, headers);

        ResponseEntity<ShareAppInfo> forEntity = restTemplate.postForEntity(url, httpEntity, ShareAppInfo.class);

        ShareAppInfo result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result.getCorpList();
    }

    /**
     * 获取下游accessToken
     * @param accessToken
     * @param corpId
     * @param agentId
     * @return
     */
    public String getDownstreamAccessToken(@NonNull String accessToken, @NonNull String corpId, @NonNull Integer agentId) throws WeworkException {
        String url = MessageFormat.format(downstreamAccessTokenUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        AccessTokenReq req = new AccessTokenReq();
        req.setCorpId(corpId);
        req.setAgentId(agentId);
        req.setBusinessType(1);
        HttpEntity<AccessTokenReq> httpEntity = new HttpEntity<>(req, headers);

        ResponseEntity<DownstreamAccessToken> forEntity = restTemplate.postForEntity(url, httpEntity, DownstreamAccessToken.class);

        DownstreamAccessToken result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result.getAccessToken();
    }

    /**
     * 获取下游external_user_id
     * @param accessToken
     * @param corpId
     * @param openId
     * @param unionId
     * @return
     */
    public List<CorpExternalUserId> getDownstreamExternalUserId(@NonNull String accessToken, @NonNull String openId, @NonNull String unionId, @GenNullable String corpId) throws WeworkException {
        String url = MessageFormat.format(downstreamExternalUserIdUrl, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        GetExternalUserIdReq req = new GetExternalUserIdReq();
        req.setOpenId(openId);
        req.setUnionId(unionId);
        req.setCorpId(corpId);
        HttpEntity<GetExternalUserIdReq> httpEntity = new HttpEntity<>(req, headers);

        ResponseEntity<ExternalUserIdInfo> forEntity = restTemplate.postForEntity(url, httpEntity, ExternalUserIdInfo.class);

        ExternalUserIdInfo result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result.getExternalUserIdInfos();
    }
}
