package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.api.req.AddCalendarReq;
import cn.kinyun.wework.sdk.api.req.CalendarDetailReq;
import cn.kinyun.wework.sdk.entity.calendar.CalendarAddResp;
import cn.kinyun.wework.sdk.entity.calendar.CalendarDetailResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;

/**
 * 日历API
 * @author sunwen
 */
@Component
public class CalendarApi {

    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    /**
     * 创建日历
     */
    @Value("${qyapi.calendar.add}")
    private String addCalendar;

    @Value("${qyapi.calendar.get}")
    private String calendarDetail;

    public CalendarAddResp addCalendar(@NonNull String accessToken, @NonNull AddCalendarReq params) throws WeworkException {
        String url = MessageFormat.format(addCalendar, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<AddCalendarReq> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<CalendarAddResp> forEntity = restTemplate.postForEntity(url, httpEntity, CalendarAddResp.class);

        CalendarAddResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }

    public CalendarDetailResp getCalendarDetail(@NonNull String accessToken, @NonNull CalendarDetailReq params) throws WeworkException {
        String url = MessageFormat.format(calendarDetail, accessToken);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);

        HttpEntity<CalendarDetailReq> httpEntity = new HttpEntity<>(params, headers);

        ResponseEntity<CalendarDetailResp> forEntity = restTemplate.postForEntity(url, httpEntity, CalendarDetailResp.class);

        CalendarDetailResp result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }


}
