package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;

import lombok.NonNull;

/**
 * 获取accessToken
 */
@Component
@GenIgnore
public class AccessTokenApi {
    @Autowired
    @Qualifier("weworkRestTemplate")
    private RestTemplate restTemplate;

    @Value("${qyapi.get_token}")
    private String getAccessTokenUrl;

    /**
     * @param corpId 企业ID
     * @param corpSecret 应用的凭证密钥
     * @desc 获取access_token
     * @link https://open.work.weixin.qq.com/api/doc/90000/90135/91039
     * @see <a href="https://open.work.weixin.qq.com/api/doc/90000/90135/90665#secret">术语说明-corpsecret</a>
     */
    public AccessToken getAccessToken(@NonNull String corpId, @NonNull String corpSecret) throws WeworkException {
        String url = MessageFormat.format(getAccessTokenUrl, corpId, corpSecret);

        ResponseEntity<AccessToken> forEntity = restTemplate.getForEntity(url, AccessToken.class);

        AccessToken result = forEntity.getBody();
        WeworkException.isSuccess(result);

        return result;
    }
}
