/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.license.order.CancelOrderReq;
import cn.kinyun.wework.sdk.entity.license.order.CreateNewOrderJobReq;
import cn.kinyun.wework.sdk.entity.license.order.CreateNewOrderJobResp;
import cn.kinyun.wework.sdk.entity.license.order.CreateNewOrderReq;
import cn.kinyun.wework.sdk.entity.license.order.CreateRenewOrderJobReq;
import cn.kinyun.wework.sdk.entity.license.order.CreateRenewOrderJobResp;
import cn.kinyun.wework.sdk.entity.license.order.GetOrderResp;
import cn.kinyun.wework.sdk.entity.license.order.GetUnionOrderReq;
import cn.kinyun.wework.sdk.entity.license.order.GetUnionOrderResp;
import cn.kinyun.wework.sdk.entity.license.order.JobIdDto;
import cn.kinyun.wework.sdk.entity.license.order.JobIdResp;
import cn.kinyun.wework.sdk.entity.license.order.ListOrderAccountReq;
import cn.kinyun.wework.sdk.entity.license.order.ListOrderAccountResp;
import cn.kinyun.wework.sdk.entity.license.order.ListOrderReq;
import cn.kinyun.wework.sdk.entity.license.order.ListOrderResp;
import cn.kinyun.wework.sdk.entity.license.order.NewOrderJobResultResp;
import cn.kinyun.wework.sdk.entity.license.order.OrderIdDto;
import cn.kinyun.wework.sdk.entity.license.order.OrderIdResp;
import cn.kinyun.wework.sdk.entity.license.order.SubmitNewOrderJobReq;
import cn.kinyun.wework.sdk.entity.license.order.SubmitOrderJobReq;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class LicenseOrderApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.license.create_new_order}")
    private String licenseCreateNewOrderUrl;
    @Value(value="${qyapi.license.create_renew_order_job}")
    private String licenseCreateRenewOrderJobUrl;
    @Value(value="${qyapi.license.submit_order_job}")
    private String licenseSubmitOrderJobUrl;
    @Value(value="${qyapi.license.list_order}")
    private String licenseListOrderUrl;
    @Value(value="${qyapi.license.get_order}")
    private String licenseGetOrderUrl;
    @Value(value="${qyapi.license.list_order_account}")
    private String licenseListOrderAccountUrl;
    @Value(value="${qyapi.license.cancel_order}")
    private String licenseCancelOrderUrl;
    @Value(value="${qyapi.license.create_new_order_job}")
    private String licenseCreateNewOrderJobUrl;
    @Value(value="${qyapi.license.submit_new_order_job}")
    private String licenseSubmitNewOrderJobUrl;
    @Value(value="${qyapi.license.new_order_job_result}")
    private String licenseNewOrderJobResultUrl;
    @Value(value="${qyapi.license.get_union_order}")
    private String licenseGetUnionOrderUrl;

    public String createNewOrder(@NonNull String accessToken, @NonNull CreateNewOrderReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseCreateNewOrderUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderIdResp.class, new Object[0]);
        OrderIdResp result = (OrderIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getOrderId();
    }

    public CreateRenewOrderJobResp createRenewOrderJob(@NonNull String accessToken, @NonNull CreateRenewOrderJobReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseCreateRenewOrderJobUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CreateRenewOrderJobResp.class, new Object[0]);
        CreateRenewOrderJobResp result = (CreateRenewOrderJobResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public String submitOrderJob(@NonNull String accessToken, @NonNull SubmitOrderJobReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseCreateNewOrderUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderIdResp.class, new Object[0]);
        OrderIdResp result = (OrderIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getOrderId();
    }

    public ListOrderResp listOrder(@NonNull String accessToken, @NonNull ListOrderReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseListOrderUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ListOrderResp.class, new Object[0]);
        ListOrderResp result = (ListOrderResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public GetOrderResp getOrder(@NonNull String accessToken, @NonNull String orderId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (orderId == null) {
            throw new NullPointerException("orderId is marked non-null but is null");
        }
        OrderIdDto req = new OrderIdDto();
        req.setOrderId(orderId);
        String url = MessageFormat.format(this.licenseGetOrderUrl, accessToken, orderId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GetOrderResp.class, new Object[0]);
        GetOrderResp result = (GetOrderResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public ListOrderAccountResp listOrderAccount(@NonNull String accessToken, @NonNull ListOrderAccountReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseListOrderAccountUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ListOrderAccountResp.class, new Object[0]);
        ListOrderAccountResp result = (ListOrderAccountResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public void cancelOrder(@NonNull String accessToken, @NonNull CancelOrderReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseCancelOrderUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    public CreateNewOrderJobResp createNewOrderJob(@NonNull String accessToken, @NonNull CreateNewOrderJobReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseCreateNewOrderJobUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CreateNewOrderJobResp.class, new Object[0]);
        CreateNewOrderJobResp result = (CreateNewOrderJobResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public String submitNewOrderJob(@NonNull String accessToken, @NonNull SubmitNewOrderJobReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseSubmitNewOrderJobUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, JobIdResp.class, new Object[0]);
        JobIdResp result = (JobIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getJobId();
    }

    public NewOrderJobResultResp getNewOrderJob(@NonNull String accessToken, @NonNull String jobId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        JobIdDto req = new JobIdDto();
        req.setJobId(jobId);
        String url = MessageFormat.format(this.licenseNewOrderJobResultUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, NewOrderJobResultResp.class, new Object[0]);
        NewOrderJobResultResp result = (NewOrderJobResultResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public GetUnionOrderResp getUnionOrder(@NonNull String accessToken, @NonNull GetUnionOrderReq req) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String url = MessageFormat.format(this.licenseGetUnionOrderUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GetUnionOrderResp.class, new Object[0]);
        GetUnionOrderResp result = (GetUnionOrderResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

