/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.material.GetMaterialResp;
import cn.kinyun.wework.sdk.entity.material.UploadImageMaterialResult;
import cn.kinyun.wework.sdk.entity.material.UploadMaterialResult;
import cn.kinyun.wework.sdk.exception.WeworkException;
import cn.kinyun.wework.sdk.utils.JacksonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestTemplate;

@GenIgnore
@Component
public class WwMaterialApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.material.manager.upload}")
    private String materialUploadUrl;
    @Value(value="${qyapi.material.manager.uploadimage}")
    private String materialUploadImageUrl;
    @Value(value="${qyapi.material.manager.gettempmaterial}")
    private String getTempMaterialUrl;
    @Value(value="${qyapi.material.manager.getvoicematerial}")
    private String getVoiceMaterialUrl;

    public UploadMaterialResult uploadMaterial(@NonNull String accessToken, @NonNull String type, @NonNull File file) throws IOException, WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String url = MessageFormat.format(this.materialUploadUrl, accessToken, type);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)file.getName());
        param.add((Object)"filelength", (Object)resource.contentLength());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UploadMaterialResult.class, new Object[0]);
        UploadMaterialResult result = (UploadMaterialResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public UploadImageMaterialResult uploadImageMaterial(@NonNull String accessToken, @NonNull File file) throws IOException, WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String url = MessageFormat.format(this.materialUploadImageUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)file.getName());
        param.add((Object)"filelength", (Object)resource.contentLength());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UploadImageMaterialResult.class, new Object[0]);
        UploadImageMaterialResult result = (UploadImageMaterialResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public GetMaterialResp getMaterial(@NonNull String accessToken, @NonNull String mediaId, @NonNull String filePath) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getTempMaterialUrl, accessToken, mediaId);
        RequestCallback requestCallback = request -> request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL));
        GetMaterialResp result = new GetMaterialResp();
        this.restTemplate.execute(url, HttpMethod.GET, requestCallback, clientHttpResponse -> {
            ContentDisposition contentDisposition;
            HttpHeaders headers = clientHttpResponse.getHeaders();
            InputStream body = clientHttpResponse.getBody();
            MediaType contentType = headers.getContentType();
            if (contentType != null && (contentType.getType().equals(MediaType.TEXT_PLAIN.getType()) || contentType.getType().equals(MediaType.APPLICATION_JSON.getType()))) {
                String textString = IOUtils.toString((InputStream)body, (Charset)StandardCharsets.UTF_8);
                GetMaterialResp resp = JacksonUtils.readValue(textString, GetMaterialResp.class);
                result.setErrCode(resp.getErrCode());
                result.setErrMsg(resp.getErrMsg());
            } else if (contentType != null && "attachment".equals((contentDisposition = headers.getContentDisposition()).getType())) {
                String fileName = contentDisposition.getFilename();
                StringBuilder mediaPath = new StringBuilder(filePath);
                if (filePath.endsWith(File.separator)) {
                    mediaPath.append(fileName);
                } else {
                    mediaPath.append(File.separator);
                    mediaPath.append(fileName);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(mediaPath.toString());
                IOUtils.copy((InputStream)body, (OutputStream)fileOutputStream);
                String type = contentType.getType().split("/")[0];
                result.setFileOutputStream(fileOutputStream);
                result.setType(type);
                result.setErrCode(Integer.valueOf(0));
            }
            return null;
        }, new Object[0]);
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public GetMaterialResp getVoiceMaterial(@NonNull String accessToken, @NonNull String mediaId, @NonNull String filePath) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getVoiceMaterialUrl, accessToken, mediaId);
        RequestCallback requestCallback = request -> request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL));
        GetMaterialResp result = new GetMaterialResp();
        this.restTemplate.execute(url, HttpMethod.GET, requestCallback, clientHttpResponse -> {
            ContentDisposition contentDisposition;
            HttpHeaders headers = clientHttpResponse.getHeaders();
            InputStream body = clientHttpResponse.getBody();
            MediaType contentType = headers.getContentType();
            if (contentType != null && (contentType.getType().equals(MediaType.TEXT_PLAIN.getType()) || contentType.getType().equals(MediaType.APPLICATION_JSON.getType()))) {
                String textString = IOUtils.toString((InputStream)body, (Charset)StandardCharsets.UTF_8);
                GetMaterialResp resp = JacksonUtils.readValue(textString, GetMaterialResp.class);
                result.setErrCode(resp.getErrCode());
                result.setErrMsg(resp.getErrMsg());
            } else if (contentType != null && "attachment".equals((contentDisposition = headers.getContentDisposition()).getType())) {
                String fileName = contentDisposition.getFilename();
                StringBuilder mediaPath = new StringBuilder(filePath);
                if (filePath.endsWith(File.separator)) {
                    mediaPath.append(fileName);
                } else {
                    mediaPath.append(File.separator);
                    mediaPath.append(fileName);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(mediaPath.toString());
                IOUtils.copy((InputStream)body, (OutputStream)fileOutputStream);
                String type = contentType.getType().split("/")[0];
                result.setFileOutputStream(fileOutputStream);
                result.setType(type);
                result.setErrCode(Integer.valueOf(0));
            }
            return null;
        }, new Object[0]);
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

