package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ExcelIgnoreUnannotated
public class DormCleanTaskResp implements Serializable {

    /**
     * 打扫任务id
     */
    private Long id;

    @ExcelProperty("编号")
    @ColumnWidth(20)
    private String num;

    /**
     * 楼栋
     */
    @ExcelProperty("楼栋")
    @ColumnWidth(15)
    private Integer block;

    /**
     * 楼层
     */
    @ExcelProperty("楼层")
    @ColumnWidth(15)
    private Integer floor;

    /***
     * 房间号
     */
    @ExcelProperty("房间号")
    @ColumnWidth(20)
    private String roomNo;

    /**
     * 床号
     */
    @ExcelProperty("床号")
    @ColumnWidth(20)
    private String bedNo;

    /**
     * 上报人手机号
     */
    @ExcelProperty("上报人手机号")
    @ColumnWidth(25)
    private String reportMobile;

    /**
     * 上报人手姓名
     */
    @ExcelProperty("上报人姓名")
    @ColumnWidth(20)
    private String reporterName;

    /**
     * 打扫时间
     */
    @ExcelProperty("打扫时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(25)
    private Date cleanTime;

    /**
     * 跟进员工
     */
    @ExcelProperty("跟进员工")
    @ColumnWidth(23)
    private String followUserName;

    /**
     * 状态
     */
    private Integer status;
    @ExcelProperty("状态")
    @ColumnWidth(18)
    private String statusDesc;

    @ExcelProperty("上报时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(25)
    private Date reportTime;

}
