package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel("退房任务响应实体")
@ExcelIgnoreUnannotated
public class DormCheckoutTaskResp implements Serializable {

    private Long id;

    @ExcelProperty("任务编号")
    @ColumnWidth(20)
    private String num;

    @ExcelProperty("楼栋")
    @ColumnWidth(15)
    private Integer block;

    @ExcelProperty("房间号")
    @ColumnWidth(18)
    private String roomNo;

    @ExcelProperty("床号")
    @ColumnWidth(18)
    private String bedNo;

    @ExcelProperty("上报人姓名")
    @ColumnWidth(23)
    private String reporterName;

    @ExcelProperty("跟进人姓名")
    @ColumnWidth(23)
    private String followerUserName;

    private Integer depositStatus;
    @ApiModelProperty("押金状态描述")
    private String depositStatusDesc;

    @ExcelProperty("住宿人姓名")
    @ColumnWidth(20)
    private String studentName;
    @ExcelProperty("住宿人电话")
    @ColumnWidth(20)
    private String studentMobile;

    @ExcelProperty("入住时间")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(20)
    private Date checkinTime;

    @ExcelProperty("退房时间")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(20)
    private Date checkoutTime;

    private Integer status;
    @ExcelProperty ("状态")
    @ColumnWidth(18)
    private String statusDesc;

    @ExcelProperty("班级")
    @ColumnWidth(20)
    private String className;

    @ExcelProperty("班级编号")
    @ColumnWidth(20)
    private String classCode;

    @ExcelProperty("教务")
    @ColumnWidth(20)
    private String teacherName;

    @ApiModelProperty(value = "在班状态")
    private Integer onClassStatus;
    @ExcelProperty("在班状态")
    @ColumnWidth(20)
    private String onClassStatusDesc;

    @ApiModelProperty(value = "退房原因")
    private String checkoutReason = "学生报退";

    @ExcelProperty("上报时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(20)
    private Date reportTime;
}
