package cn.kinyun.trade.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 退款类型
 */
public enum RefundTypeEnum {
    ADJUST_PAY(-1, "调账收款"),
    ADJUST_REFUND(-2, "调账退款"),
    PRICE_SPREAD(-3, " 退差价"),
    MULTI_PROJECT_PASSED(0, "多项目通过协议退费"),
    QUIT_BEFORE_START(1, "课前退款"),
    QUIT_BEFORE_END(2, "课中退款"),
    PROTOCOL_REFUND(3, "协议退款"),
    APPEAL_REFUND(4, "申诉退款"),
    OTHER_REFUND(5, "其他退款"),

    TRANSFER_BEFORE_START(6, "课前转课"),
    TRANSFER_BEFORE_END(7, "课中转课"),
    PROTOCOL_REFUND_TRANSFER(8, "协议退费转课"),
    ADVANCE_PROTOCOL_REFUND_TRANSFER(9, "提前协议退费转课"),
    ADVANCE_PROTOCOL_REFUND(10, "提前协议退费")
    ;

    private int value;
    private String name;

    RefundTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return name;
    }

    private static final Map<Integer, RefundTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (RefundTypeEnum item : RefundTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static RefundTypeEnum get(int value) {
        return cache.get(value);
    }
}