package cn.kinyun.trade.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 退款类型
 */
public enum OrderTypeEnum {
    DISCOUNT_ORDER(1, "优惠券订单"),
    COURSE_ORDER(2, "课程订单");

    private final int value;
    private final String name;

    OrderTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return name;
    }

    private static final Map<Integer, OrderTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (OrderTypeEnum item : OrderTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static OrderTypeEnum get(int value) {
        return cache.get(value);
    }
}