package cn.kinyun.trade.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author zyl
 */
@ApiModel("订单列表请求")
@Data
public class OrderQuery implements Serializable {

    private String corpId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("名字")
    private String studentName;

    @ApiModelProperty("报名分校ID")
    private Long entryNodeId;

    @ApiModelProperty("支付状态")
    private Integer payStatus;

    @ApiModelProperty("订单对应课程退费状态")
    private Integer refundStatus;

    //产品表
    private boolean joinProduct = false;

    @ApiModelProperty("项目编码")
    private String bizUnitCode;

    @ApiModelProperty("考试类型编码")
    private String examTypeCode;

    @ApiModelProperty("产品类型编码")
    private String productTypeCode;

    @ApiModelProperty("协议类型编码")
    private String protocolCode;

    @ApiModelProperty("创建开始日期")
    private Date createStartDate;

    @ApiModelProperty("创建日期结束时间")
    private Date createEndDate;

    @ApiModelProperty("成单人")
    private Long salesId;

    @ApiModelProperty("成单分校")
    private Long salesNodeId;

    @ApiModelProperty("开课起始时间1")
    private Date classStartDate1;

    @ApiModelProperty("开课起始时间2")
    private Date classStartDate2;

    @ApiModelProperty("结课起始时间1")
    private Date classEndDate1;

    @ApiModelProperty("结课起始时间2")
    private Date classEndDate2;

    //分页
    private Integer offset;

    private Integer limit;

    /**
     * 订单主键id列表
     **/
    private Collection<Long> ids;
    /**
     * 课程编码列表
     **/
    private List<String> courseCodeList;
    /**
     * 课程编码精确查询或课程名称模糊查询
     **/
    private String queryCourse;
    //课程表
    private boolean joinCourse = false;
    private Collection<Long> manageUserIds;
    /**
     * 选中的订单编号
     **/
    private Collection<String> bindingIds;

    private Set<String> bizUnitCodes;

    /**
     * 当前操作人
     **/
    private Long userId;

    /**
     * 是否关联student表
     */
    private boolean joinStudent = false;
    private Integer verifyStatus;

    /**
     * 开课分校
     **/
    private Long branchSchoolId;

    /**
     * 是否关联order_contract表
     */
    private boolean joinOrderContract;
    private Integer signStatus;

    /**
     * 先交后补首付款已付已付
     **/
    private boolean joinOrderProtocolRule;

    private Integer downPaidStatus;

    private Long positionId;

    private boolean joinPosition = false;

    private boolean joinPositionInterview = false;

    /**
     * 进面状态 1为进面，0为未进面
     **/
    private Integer interviewStatus;

    /**
     * 招录职位代码
     **/
    private String recruitCode;

    /**
     * 成绩状态 1为已录  2为未录， 3 已录审批中
     **/
    private Integer scoreStatus;

    private boolean joinScore = false;
    private Integer orderType;
    private String examPeriod;
    private Collection<String> examPeriods;

    /**
     * 被分享的订单
     **/
    private Set<Long> shareIds;

    private Set<Integer> refundStatusSet;

    private boolean joinOrderRefund = false;
    private Integer contractSmsFlag;

    /**
     * 订单是否携带职位
     **/
    private Integer isWidthPosition;

    /**
     * 仅查找主订单
     **/
    private boolean onlyPrimaryOrder;

    private Integer isSubOrder;

    /**
     * 是否查询分享订单
     **/
    private boolean queryShareOrder;

    /**
     * 签约分校
     */
    private Long signNodeId;

    /**
     * 当前人所在分校
     **/
    private Long userSchoolId;

    /**
     * 管理的分校ids
     **/
    private Collection<Long> manageSchoolIds;
}
