package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ExcelIgnoreUnannotated
public class DormRoomResp implements Serializable {

    private Long id;

    @ExcelProperty("基地名称")
    @ColumnWidth(20)
    private String baseName;

    @ExcelProperty("房间编号")
    @ColumnWidth(20)
    private String roomNo;

    @ExcelProperty("楼栋")
    @ColumnWidth(15)
    private Integer block;

    @ExcelProperty("楼层")
    @ColumnWidth(15)
    private Integer floor;

    private Integer type;
    @ExcelProperty("房型")
    @ColumnWidth(15)
    private String typeDesc;


    @ExcelProperty("已住人数")
    @ColumnWidth(20)
    private Integer occupiedCount;

    @ExcelProperty("可分配床位数")
    @ColumnWidth(20)
    private Integer canAllocateBedCount;

    @ExcelProperty("总床位数")
    @ColumnWidth(20)
    private Integer bedCount;

    @ExcelProperty("最近打扫日期")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(20)
    private Date lastCleanTime;

    @ExcelProperty("距离下次打扫天数")
    @ColumnWidth(25)
    private Integer nextCleanDays;

    private Integer status;
    @ExcelProperty("状态")
    @ColumnWidth(18)
    private String statusDesc;

    private Integer gender;
    @ExcelProperty("性别")
    @ColumnWidth(15)
    private String genderDesc;

    @ExcelProperty("备注")
    @ColumnWidth(30)
    private String remark;

    private Integer residentType;
    @ExcelProperty("住宿人类型")
    @ColumnWidth(20)
    private String residentTypeDesc;

    @ExcelProperty("临时密码")
    @ColumnWidth(20)
    private String tempPwd;

    @ExcelProperty("临时密码有效期")
    @ColumnWidth(20)
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private Date tempPwdExpireTime;

}
