package cn.kinyun.trade.dto;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DormRoomListReq implements Serializable {

    /**
     * 房号
     */
    private String roomNo;

    /**
     * 距离N天需打扫数
     */
    private Integer daysNextCleaning;

    /**
     * 可分配床铺数
     */
    private Integer canAllocateBedCount;

    /**
     * 楼栋
     */
    private Integer block;

    private Integer floor;

    /**
     * 包含脏铺
     */
    private Boolean containDirtyBed;

    /**
     * 房型
     */
    private Integer type;

    /**
     * 上次打扫日期
     */
    private Date lastCleanTimeBegin;
    private Date lastCleanTimeEnd;

    /**
     * 性别
     */
    private Integer gender;

    /**
     * 预计退房时间
     */
    private Date checkoutTimeBegin;
    private Date checkoutTimeEnd;

    /**
     * 房间状态 0:不可用 1:可用
     */
    private Integer status;

    private Integer residentType;

    private PageDto pageDto;
}
