package cn.kinyun.trade.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ExcelIgnoreUnannotated
public class DormMaintainTaskResp implements Serializable {

    /**
     * 任务id
     */
    private Long id;

     @ExcelProperty("任务编号")
     @ColumnWidth(20)
     private String num;

     @ExcelProperty("楼栋")
     @ColumnWidth(18)
     private Integer block;

    /**
     * 房号
     */
    @ExcelProperty("房间号")
    @ColumnWidth(15)
    private String roomNo;

    /**
     * 床号
     */
    @ExcelProperty("床号")
    private String bedNo;

    /**
     * 上报姓名
     */
    @ExcelProperty("上报人姓名")
    @ColumnWidth(23)
    private String reporterName;

    /**
     * 上报名手机号
     */
    @ExcelProperty("上报人手机号")
    @ColumnWidth(25)
    private String reporterMobile;

    /**
     * 上报时间
     */
    @ExcelProperty("上报时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(25)
    private Date reportTime;

    /**
     * 跟进员工
     */
    @ExcelProperty("跟进人姓名")
    @ColumnWidth(22)
    private String followUserName;

    /**
     * 状态
     */
    private Integer status;
    @ExcelProperty("状态")
    private String statusDesc;

    /**
     * 问题描述
     */
    @ExcelProperty("问题描述")
    @ColumnWidth(30)
    private String questionDesc;

    /**
     * 图片地址
     */
    private String urls;

    /**
     * 备注
     */
    private String remark;
}
