package cn.kinyun.trade.dto;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

@Data
@ApiModel("退房任务实体")
public class DormCheckoutListReq implements Serializable {

    private Boolean isExport = false;

    private String num;

    private Set<Long> manageUserIds;

    @ApiModelProperty(value = "班级名称")
    private String className;

    @ApiModelProperty(value = "班级编号")
    private String classCode;

    @ApiModelProperty(value = "上报时间")
    private Date reportTimeBegin;
    private Date reportTimeEnd;

    @ApiModelProperty(value = "状态：1-待处理，2-处理中，3-已处理")
    private Integer status;

    @ApiModelProperty(value = "学生姓名/手机号")
    private String studentQuery;

    @ApiModelProperty(value = "教务老师id")
    private Long chargeManId;

    private Long followUserId;

    private PageDto pageDto;

    public boolean isNeedQueryStudentIds() {
        return StringUtils.isNotBlank(className)
               || StringUtils.isNotBlank(classCode)
               || StringUtils.isNotBlank(studentQuery)
               || Objects.nonNull(chargeManId);
    }

}
