/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import cn.kinyun.trade.common.utils.NamedThreadFactory;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolMonitorUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"threadPoolMonitorLog");
    @Autowired
    private HikariDataSource hikariDataSource;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new NamedThreadFactory("ThreadPoolMoniter"));
    private static CopyOnWriteArrayList<ThreadPoolExecutor> toPrintThreadPools = new CopyOnWriteArrayList();

    @PostConstruct
    public void print() {
        toPrintThreadPools.add((ScheduledThreadPoolExecutor)this.executorService);
        Runnable printTask = () -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\u7ebf\u7a0b\u6c60\u76d1\u63a7:\n");
            buffer.append("| pool status | pool size | active | queued | completed | ThreadFactory\n");
            for (ThreadPoolExecutor executorService : toPrintThreadPools) {
                this.printThreadPoolStatus(executorService, buffer);
            }
            this.dataSourcePoolMonitor(buffer);
            log.info("{}", (Object)buffer.toString());
        };
        this.executorService.scheduleWithFixedDelay(printTask, 30L, 30L, TimeUnit.SECONDS);
    }

    private void dataSourcePoolMonitor(StringBuffer buffer) {
        HikariPoolMXBean hikariPoolMXBean = this.hikariDataSource.getHikariPoolMXBean();
        if (hikariPoolMXBean == null) {
            return;
        }
        int activeConnections = hikariPoolMXBean.getActiveConnections();
        int idleConnections = hikariPoolMXBean.getIdleConnections();
        int totalConnections = hikariPoolMXBean.getTotalConnections();
        int threadsAwaitingConnection = hikariPoolMXBean.getThreadsAwaitingConnection();
        buffer.append("Hikari Pool ");
        buffer.append("active:").append(activeConnections).append(", ");
        buffer.append("idle:").append(idleConnections).append(", ");
        buffer.append("total:").append(totalConnections).append(", ");
        buffer.append("awaiting:").append(threadsAwaitingConnection);
    }

    private void printThreadPoolStatus(ThreadPoolExecutor tpe, StringBuffer buffer) {
        String namePrefix = "";
        ThreadFactory threadFactory = tpe.getThreadFactory();
        if (threadFactory instanceof NamedThreadFactory) {
            NamedThreadFactory namedThreadFactory = (NamedThreadFactory)threadFactory;
            namePrefix = namedThreadFactory.getNamePrefix();
        } else {
            namePrefix = "Unknown-" + threadFactory.getClass().getSimpleName();
        }
        if (StringUtils.isBlank((CharSequence)namePrefix)) {
            return;
        }
        String status = !tpe.isShutdown() ? "Running" : (tpe.isTerminated() ? "Terminated" : "Terminating");
        buffer.append(String.format("| %-11s | %9d | %6d | %6d | %9d | %s\n", status, tpe.getPoolSize(), tpe.getActiveCount(), tpe.getQueue().size(), tpe.getCompletedTaskCount(), namePrefix));
    }

    public static void addToMonitor(ExecutorService executorService) {
        try {
            if (executorService instanceof ThreadPoolExecutor) {
                toPrintThreadPools.add((ThreadPoolExecutor)executorService);
            }
        }
        catch (Exception e) {
            log.error("addToMonter error", (Throwable)e);
        }
    }

    public void addToMonitor2(ExecutorService executorService) {
        try {
            if (executorService instanceof ThreadPoolExecutor) {
                toPrintThreadPools.add((ThreadPoolExecutor)executorService);
            }
        }
        catch (Exception e) {
            log.error("addToMonter error", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdown();
        toPrintThreadPools.stream().forEach(ThreadPoolExecutor::shutdown);
        toPrintThreadPools.clear();
        log.info("monitor destroy success");
    }
}

