/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.trade.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA1Utils {
    private static final Logger log = LoggerFactory.getLogger(SHA1Utils.class);
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String digest(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return "";
        }
        byte[] input = message.getBytes();
        try {
            MessageDigest mDigest = MessageDigest.getInstance("SHA1");
            byte[] digest = mDigest.digest(input);
            return SHA1Utils.toHexStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            log.error("Failed calculate digest for message={}", (Object)message, (Object)e);
            return "";
        }
    }

    private static String toHexStr(byte[] b) {
        StringBuffer sb = new StringBuffer(36);
        for (int i = 0; i < b.length; ++i) {
            int n = b[i] & 0xFF;
            int hb = n >> 4;
            int lb = n % 16;
            sb.append(HEX_CHARS[hb]).append(HEX_CHARS[lb]);
        }
        return sb.toString();
    }

    public static String getSha1(byte[] data) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data, 0, data.length);
            String sha1 = new BigInteger(1, digest.digest()).toString(16);
            int length = 40 - sha1.length();
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    sb.append("0");
                }
            }
            sb.append(sha1);
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSha1(File file) {
        FileInputStream in = null;
        StringBuilder sb = new StringBuilder();
        try {
            in = new FileInputStream(file);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[0xA00000];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                digest.update(buffer, 0, len);
            }
            String sha1 = new BigInteger(1, digest.digest()).toString(16);
            int length = 40 - sha1.length();
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    sb.append("0");
                }
            }
            sb.append(sha1);
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

